<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright JDSU 2019. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;

/**
 * 
 * @author Sylvain Desplat
 */
class SMTRelayDto extends SMTRwDto
{
	/**
	 * Option relay
	 * 
	 * @var boolean
	 */
	protected $relayOption = FALSE;
    /**
     * by default, HDD status is OK
     * 
     * @var boolean
     */
	protected $unitOpened = FALSE;
	/**
	 * 
	 * @var boolean
	 */
	protected $optmajOpened = FALSE;
	/**
	 * 
	 * @var boolean
	 */
	protected $optminOpened = FALSE;
	
	/**
	 * @param boolean relay option
	 */
	public function setRelayOption( $relayOption)
	{
		$this->relayOption= $relayOption;
	}
	
	/**
	 * @param boolean unit relay
	 */
	public function setUnitOpened( $opened)
	{
		$this->unitOpened= $opened;
	}
	
	/**
	 * @return boolean
	 */
	public function isUnitOpened()
	{
		return $this->unitOpened;
	}

	/**
	 * @param boolean unit relay
	 */
	public function setOptMajOpened( $opened)
	{
		$this->optmajOpened= $opened;
	}
	
	/**
	 * @return boolean
	 */
	public function isOptMajOpened()
	{
		return $this->optmajOpened;
	}

	/**
	 * @param boolean unit relay
	 */
	public function setOptMinOpened( $opened)
	{
		$this->optminOpened= $opened;
	}
	
	/**
	 * @return boolean
	 */
	public function isOptMinOpened()
	{
		return $this->optminOpened;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTSmsDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>