<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;

class SMTIpv6DTo extends SMTRwDto
{
    /**
     * @var boolean
     */    
	protected $ipv6Active;
	/**
	 * @var boolean
	 */	
	protected $isDHCP;
	/**
	 * @var string
	 */	
    protected $ip;
    /**
     * @var string
     */    
	protected $gateway;
	/**
	 * @var string
	 */	
	protected $site;
	/**
	 * @var string
	 */	
	protected $linkip;
	/**
	 * @var string
	 */	
	protected $dns;
	
	public function setMode( $mode )
	{
		$this->isDHCP = (SMTDHCPValues::DHCP == $mode );
		$this->ipv6Active = (SMTDHCPValues::OFF != $mode );
	}
	
	public function setIp( $ip )
	{
		$this->ip = $ip;
	}
		
	public function setGateway( $gateway )
	{
		$this->gateway = $gateway;
	}
	
	public function setSite( $site )
	{
		$this->site = $site;
	}
	
	public function setLinkIp( $linkip )
	{
		$this->linkip = $linkip;
	}	
	
	public function setDns( $dns )
	{
		$this->dns = $dns;
	}	
	
	public function isDHCP()
	{
		return $this->isDHCP;
	}

	public function isIpv6Active()
	{
		return $this->ipv6Active;
	}	
	
	public function getMode()
	{
		return ($this->ipv6Active) ? ( ( $this->isDHCP )? SMTDHCPValues::DHCP : SMTDHCPValues::FIX ) : SMTDHCPValues::OFF;
	}
	
	public function getIp()
	{
		return $this->ip;
	}
	
	public function getGateway()
	{
		return $this->gateway;
	}
	
	public function getSite()
	{
		return $this->site;
	}

	public function getLinkip()
	{
		return $this->linkip;
	}
		
	public function getDns()
	{
		return $this->dns;
	}	
	
	
	public function stripHtmlTags()
	{
		$this->ip= strip_tags( $this->ip);
		$this->site= strip_tags( $this->site);
		$this->gateway= strip_tags( $this->gateway);
		$this->dns= strip_tags( $this->dns);
		$this->linkip= strip_tags( $this->linkip);
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}	
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}	
	
    /**
     * Create the Dto from a Json Dto in an array
     * 
     * @param array $json_array json data in an array
     * 
     * @return \app\services\setup\SMTIpv6Dto
     */
    static function getInstance( array &$json_array )
    {
    	$instance = self::forge( get_class(), $json_array );
    	$instance->stripHtmlTags();
    	return $instance;
    }
}


?>