<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\monitoring;

use app\util\SMTRwDto;

/**
 * 
 * @author Sylvain Desplat
 */
class SMTOtuMonitoringTestThresholdDto extends SMTRwDto
{
    /**
     * @var number
     */
    const MONITORED = 1;
    /**
     * @var number
     */    
    const NOT_MONITORED = 0;    
    
    /**
     * @var boolean
     */
    protected $monitored = FALSE;
    /**
     * @var float
     */    
    protected $positiveToMinorThreshold = 0;

    /**
     * @var float
     */    
    protected $positiveToMajorThreshold = 0;

    /**
     * @var float
     */    
    protected $positiveBackToMinorThreshold = 0;

    /**
     * @var float
     */    
    protected $positiveBackToNormalThreshold = 0;

    /**
     * @var float
     */    
    protected $negativeToMinorThreshold = 0;

    /**
     * @var float
     */    
    protected $negativeToMajorThreshold = 0;

    /**
     * @var float
     */    
    protected $negativeBackToMinorThreshold = 0;

    /**
     * @var float
     */    
    protected $negativeBackToNormalThreshold = 0;
    
    /**
     * @var boolean
     */
    protected $minorThresholdEnabled = TRUE;
    
    function setMonitored( $monitored)
    {
        $this->monitored = $monitored;
    }
    
    function isMonitored()
    {
        return $this->monitored;
    }    
    
    /**
     * WARNING: don't set validators on setters: they are used to retrieve info from OTU: if value was invalid, nothing would be sent to client and the value couldn't be changed
     * @param unknown $negativeBackToNormalThreshold
     */
    function setNegativeBackToNormalThreshold($negativeBackToNormalThreshold)
    {
        $this->negativeBackToNormalThreshold = floatval($negativeBackToNormalThreshold);
    }
    /**
     * @return float
     */
    function getNegativeBackToNormalThreshold()
    {
        if ( !is_numeric( $this->negativeBackToNormalThreshold ) || $this->negativeBackToNormalThreshold > 0)
        {
        	throw new \InvalidArgumentException( sprintf ( MSG_BAD_THRESHOLD_VALUE, $this->negativeBackToNormalThreshold, "negativeBackToNormalThreshold" ) );
        }        
    	return floatval($this->negativeBackToNormalThreshold);
    }

    /**
     * WARNING: don't set validators on setters: they are used to retrieve info from OTU: if value was invalid, nothing would be sent to client and the value couldn't be changed
     * @param unknown $negativeBackToNormalThreshold
     */    
    function setNegativeBackToMinorThreshold($negativeBackToMinorThreshold)
    {        
    	$this->negativeBackToMinorThreshold = floatval($negativeBackToMinorThreshold);
    }
    /**
     * @return float
     */
    function getNegativeBackToMinorThreshold()
    {
        if ( !is_numeric( $this->negativeBackToMinorThreshold ) || $this->negativeBackToMinorThreshold > 0)
        {
        	throw new \InvalidArgumentException( sprintf ( MSG_BAD_THRESHOLD_VALUE, $this->negativeBackToMinorThreshold, "negativeBackToMinorThreshold" ) );
        }
    	return floatval($this->negativeBackToMinorThreshold);
    }    
    
    /**
     * WARNING: don't set validators on setters: they are used to retrieve info from OTU: if value was invalid, nothing would be sent to client and the value couldn't be changed
     * @param unknown $negativeBackToNormalThreshold
     */    
    function setNegativeToMajorThreshold($negativeToMajorThreshold)
    {
    	$this->negativeToMajorThreshold = floatval($negativeToMajorThreshold);
    }
    /**
     * @return float
     */
    function getNegativeToMajorThreshold()
    {
        if ( !is_numeric( $this->negativeToMajorThreshold ) || $this->negativeToMajorThreshold > 0)
        {
        	throw new \InvalidArgumentException( sprintf ( MSG_BAD_THRESHOLD_VALUE, $this->negativeToMajorThreshold, "negativeToMajorThreshold" ) );
        }
    	return floatval($this->negativeToMajorThreshold);
    }
    
    /**
     * WARNING: don't set validators on setters: they are used to retrieve info from OTU: if value was invalid, nothing would be sent to client and the value couldn't be changed
     * @param unknown $negativeBackToNormalThreshold
     */    
    function setNegativeToMinorThreshold($negativeToMinorThreshold)
    {
    	$this->negativeToMinorThreshold = floatval($negativeToMinorThreshold);
    }
    /**
     * @return float
     */
    function getNegativeToMinorThreshold()
    {
        if ( !is_numeric( $this->negativeToMinorThreshold ) || $this->negativeToMinorThreshold > 0)
        {
        	throw new \InvalidArgumentException( sprintf ( MSG_BAD_THRESHOLD_VALUE, $this->negativeToMinorThreshold, "negativeToMinorThreshold" ) );
        }
    	return floatval($this->negativeToMinorThreshold);
    }
    
    /**
     * WARNING: don't set validators on setters: they are used to retrieve info from OTU: if value was invalid, nothing would be sent to client and the value couldn't be changed
     * @param unknown $negativeBackToNormalThreshold
     */    
    function setPositiveBackToNormalThreshold($positiveBackToNormalThreshold)
    {     
    	$this->positiveBackToNormalThreshold = floatval($positiveBackToNormalThreshold);
    }
    /**
     * @return float
     */
    function getPositiveBackToNormalThreshold()
    {
        if ( !is_numeric( $this->positiveBackToNormalThreshold ) || $this->positiveBackToNormalThreshold < 0)
        {
        	throw new \InvalidArgumentException( sprintf ( MSG_BAD_THRESHOLD_VALUE, $this->positiveBackToNormalThreshold, "positiveBackToNormalThreshold" ) );
        }
    	return floatval($this->positiveBackToNormalThreshold);
    }
    
    /**
     * WARNING: don't set validators on setters: they are used to retrieve info from OTU: if value was invalid, nothing would be sent to client and the value couldn't be changed
     * @param unknown $negativeBackToNormalThreshold
     */    
    function setPositiveBackToMinorThreshold($positiveBackToMinorThreshold)
    {
    	$this->positiveBackToMinorThreshold = floatval($positiveBackToMinorThreshold);
    }
    /**
     * @return float
     */
    function getPositiveBackToMinorThreshold()
    {
        if ( !is_numeric( $this->positiveBackToMinorThreshold ) || $this->positiveBackToMinorThreshold < 0)
        {
        	throw new \InvalidArgumentException( sprintf ( MSG_BAD_THRESHOLD_VALUE, $this->positiveBackToMinorThreshold, "positiveBackToMinorThreshold" ) );
        }
    	return floatval($this->positiveBackToMinorThreshold);
    }
    /**
     * WARNING: don't set validators on setters: they are used to retrieve info from OTU: if value was invalid, nothing would be sent to client and the value couldn't be changed
     * @param unknown $negativeBackToNormalThreshold
     */    
    function setPositiveToMajorThreshold($positiveToMajorThreshold)
    {     
    	$this->positiveToMajorThreshold = floatval($positiveToMajorThreshold);
    }
    /**
     * @return float
     */
    function getPositiveToMajorThreshold()
    {
        if ( !is_numeric( $this->positiveToMajorThreshold ) || $this->positiveToMajorThreshold < 0)
        {
        	throw new \InvalidArgumentException( sprintf ( MSG_BAD_THRESHOLD_VALUE, $this->positiveToMajorThreshold, "positiveToMajorThreshold" ) );
        }
    	return floatval($this->positiveToMajorThreshold);
    }
    
    /**
     * WARNING: don't set validators on setters: they are used to retrieve info from OTU: if value was invalid, nothing would be sent to client and the value couldn't be changed
     * @param unknown $negativeBackToNormalThreshold
     */    
    function setPositiveToMinorThreshold($positiveToMinorThreshold)
    {
    	$this->positiveToMinorThreshold = floatval($positiveToMinorThreshold);
    }
    /**
     * @return float
     */
    function getPositiveToMinorThreshold()
    {
        if ( !is_numeric( $this->positiveToMinorThreshold ) || $this->positiveToMinorThreshold < 0)
        {
        	throw new \InvalidArgumentException( sprintf ( MSG_BAD_THRESHOLD_VALUE, $this->positiveToMinorThreshold, "positiveToMinorThreshold" ) );
        }
    	return floatval($this->positiveToMinorThreshold);
    }
    
    function setMinorThresholdEnabled( $enabled )
    {
    	$this->minorThresholdEnabled = $enabled;
    }
    
    function isMinorThresholdEnabled()
    {
    	return $this->minorThresholdEnabled;
    }   
    
    /**
     * Serialize as Json data the object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json array.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\monitoring\SMTOtuMonitoringTestThresholdDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }    
}
?>