<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright JDSU 2017. All rights reserved.
// *********************************************************
namespace app\services\monitoring;

use app\util\SMTRwDto;

/**
 * Peak monitoring DTO
 * 
 * @author Sylvain Desplat
 */
class SMTMonitoringPeakDto extends SMTRwDto
{          
	/**
	 * Peak thresholds
	 * @SMTAttributeInfosAnnotation(classname='app\services\monitoring\SMTOtuMonitoringTestThresholdDto')
	 * @var SMTOtuMonitoringTestThresholdDto
	 */
	protected $peakThresholds = NULL;
	
	/**
	 * 
	 * @var float
	 */
	protected $peakBottomDistanceM = 0;
	
	/**
	 *
	 * @var float
	 */
	protected $peakTopDistanceM = 0;
	
	/**
	 * 
	 * @var string
	 */
	protected $peakName;
	
	/**
	 *
	 * @var float
	 */
	protected $peakLevelDb = 0;
	
	/**
	 *
	 * @param SMTOtuMonitoringTestThresholdDto $firstMarkerThresholdsDb
	 */
	function setPeakThresholds( SMTOtuMonitoringTestThresholdDto $peakThresholds )
	{
		$this->peakThresholds = $peakThresholds;
	}
	/**
	 *
	 * @return \app\services\monitoring\SMTOtuMonitoringTestThresholdDto
	 */
	function getPeakThresholds()
	{
		return $this->peakThresholds;
	}  
	
	/**
	 * @param float $peakBottomDistanceM
	 * @throws SMTInvalidValueException
	 */
	function setPeakBottomDistanceM( $peakBottomDistanceM )
	{
		if ( !isset($peakBottomDistanceM) || $peakBottomDistanceM === NULL || !is_numeric( $peakBottomDistanceM ) )
		{
			throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "peakBottomDistanceM", $peakBottomDistanceM );
		}
		$this->peakBottomDistanceM = floatval($peakBottomDistanceM);
	}
	/**
	 * @return float
	 */
	function getPeakBottomDistanceM()
	{
		return $this->peakBottomDistanceM;
	}
	
	/**
	 * @param float $peakTopDistanceM
	 * @throws SMTInvalidValueException
	 */
	function setPeakTopDistanceM( $peakTopDistanceM )
	{
		if ( !isset($peakTopDistanceM) || $peakTopDistanceM === NULL || !is_numeric( $peakTopDistanceM ) )
		{
			throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "peakTopDistanceM", $peakTopDistanceM );
		}
		$this->peakTopDistanceM = floatval($peakTopDistanceM);
	}
	/**
	 * @return float
	 */
	function getPeakTopDistanceM()
	{
		return $this->peakTopDistanceM;
	}  
	
	/**
	 * Set peak name
	 * @param string $peakName
	 */
	function setPeakName( $peakName)
	{
		$this->peakName= $peakName;
	}
	/**
	 * Get OTDR trace name (with its extension)
	 * @return string
	 */
	function getPeakName()
	{
		return $this->peakName;
	}
	
	/**
	 *
	 * @param float $peakLevelDb
	 */
	function setPeakLevelDb( $peakLevelDb )
	{
		$this->peakLevelDb = $peakLevelDb;
	}
	/**
	 *
	 * @return float
	 */
	function getPeakLevelDb()
	{
		return $this->peakLevelDb;
	}  
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\monitoring\SMTTestDetailDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}    
}


?>