<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\serviceshelper\maintenance\SMTLicence;
use app\util\SMTRwDto;

/**
 * DTO to retrieve SmartOTU maintenance info
 *
 * @author Sylvain Desplat
 */
class SMTMaintenanceDto extends SMTRwDto
{   
    /**
     * Whether SmartOTU runs in degraded mode without a connection to OTU application
     *
     * @var boolean
     */
    protected $isDegradedMode = FALSE;

    /**
     * Whether SmartOTU runs in degraded mode without a connection to OTU application
     *
     * @var boolean
     */
    protected $isRescueMode = FALSE;
    
    /**
     * Whether OTU 5000 is blinking
     *
     * @var boolean
     */
    protected $isOtuBlinking = FALSE;
    
    /**
     * Whether the enhanced security option is active
     * @var string
     */
    protected $enhancedSecurity = SMTLicence::ENHANCED_SECURITY_OFF;
    
    /**
     * Whether the ssh keyt root access option is active
     * 
     * @var string
     */
    protected $sshKeyRootAccess = SMTLicence::SSH_KEY_ROOT_ACCESS_OFF;
    
    /**
     * Set SmartOTU degraded mode (no nconnection to OTU application).
     * 
     * @param boolean $isDegradedMode
     */
    function setDegradedMode( $isDegradedMode )
    {
        $this->isDegradedMode = $isDegradedMode;
    }
    
    /**
     * Set SmartOTU degraded mode (no nconnection to OTU application).
     *
     * @param boolean $isDegradedMode
     */
    function setRescueMode( $isRescueMode )
    {
        $this->isRescueMode = $isRescueMode;
    }
    
    /**
     * Set whether the enhanced security option is activated
     *
     * @param string
     */
    public function setEnhancedSecurity( $security )
    {
        $this->enhancedSecurity = $security;
    }
    
    /**
     * Whether the enhanced security option is activated
     * @return string
     */
    public function getEnhancedSecurity()
    {
        return $this->enhancedSecurity;
    }
    
    /**
     * Set whether the ssh Key Root Access option is activated
     *
     * @param string
     */
    public function setSshKeyRootAccess( $sshKeyRootAccess )
    {
        $this->sshKeyRootAccess = $sshKeyRootAccess;
    }
    
    /**
     * Whether the ssh Key Root Access option is activated
     * @return string
     */
    public function getSshKeyRootAccess()
    {
        return $this->sshKeyRootAccess;
    }
    
    /**
     * Set whether the OTU 5000 is blinking
     *
     * @param boolean
     */
    public function setOtuBlinking( $isBlinking )
    {
    	$this->isOtuBlinking= $isBlinking;
    }
    
    /**
     * Whether the OTU 5000 is blinking
     * @return boolean
     */
    public function isOtuBlinking()
    {
    	return $this->isOtuBlinking;
    }
    
    /**
     * Serialize as Json data (array) the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json array.
     */
    function getJsonData()
    {
        $objectProperties = get_object_vars($this);
        $this->serializeObjectAsJsonData( $objectProperties );
        return $objectProperties;
    }

    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
        return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\maintenance\SMTMaintenanceDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }
}

?>