<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution2019. All rights reserved.
// *********************************************************
namespace app\services\api;



class SMTApiSmartOtuCredentialDto extends SMTApiDto
{
	const CREDENTIAL_MAX_SIZE = 255;
	
	
	/**
	 * login
	 *
	 * @var string
	 */
	protected $newLogin;
	
	/**
	 * current Login
	 *
	 * @var string
	 */
	protected $currentLogin;
	
	/**
	 * password
	 *
	 * @var string
	 */
	protected $newPassword;
	
	/**
	 * current password
	 *
	 * @var string
	 */
	protected $currentPassword;
	
	
	public function getNewLogin()
	{
		return $this->newLogin;
	}
	
	public function getNewPassword()
	{
		return $this->newPassword;
	}
	
	public function getCurrentLogin()
	{
		return $this->currentLogin;
	}
	
	public function getCurrentPassword()
	{
		return $this->currentPassword;
	}
	
	public function stripHtmlTags()
	{
		$this->newLogin= strip_tags( $this->newLogin);
		$this->newPassword= strip_tags( $this->newPassword);
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\api\SMTApiLinkDto
	 */
	static function getInstance( array &$json_array )
	{
		$instance = self::forge( get_class(), $json_array );
		$instance->stripHtmlTags();
		return $instance;
	}
}