<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2019. All rights reserved.
// *********************************************************
namespace app\services\api;

/**
 * 
 *
 * @author sdesplat
 */
class SMTApiLinkDto extends SMTApiDto
{
	/**
	 * Port Number
	 *
	 * @var integer
	 */
	protected $portNumber;
	
	/**
	 * Link name
	 *
	 * @var string
	 */
	protected $name;
	
	/**
	 * Whether link is monitored
	 *
	 * @var boolean
	 */
	protected $isMonitored = FALSE;
	
	
	public function setPortNumber($portNumber)
	{
		$this->portNumber= intval($portNumber);
	}
	
	public function getPortNumber()
	{
		return intval($this->portNumber);
	}
	
	public function setName($name)
	{
		$this->name= $name;
	}
	
	public function getName()
	{
		return $this->name;
	}
	
	public function setMonitored($monitored)
	{
		$this->isMonitored= filter_var( $monitored, FILTER_VALIDATE_BOOLEAN );
	}
	
	public function isMonitored()
	{
		return filter_var( $this->isMonitored, FILTER_VALIDATE_BOOLEAN );
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
	
	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\api\SMTApiLinkDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}