<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\http;

use app\services\alarm\webservice\SMTWsAlarmDto;

use app\util\SMTLogger;

/**
 * Http JSON Post
 *
 * @author sdesplat
 */
class SMTHttpPostJson
{
    /**
     * url of the web service. By default local web server for tests
     * 
     * @var String
     */
    private $serverUrl = "http://127.0.0.1/ws/alarm";
    
    /**
     * Set the url of the web service
     * 
     * @param String $serverUrl
     */
    public function setServerUrl($serverUrl)
    {
        $this->serverUrl = $serverUrl;
    }
    
    /**
     * Send an alarm to a web service with the url set in the class
     *
     * @param SMTWsAlarmDto $alarm
     */
    public function postJsonData( SMTWsAlarmDto $alarm )
    {
        $content = json_encode( $alarm->getJsonData() );//  json_encode("your data to be sent");
        
        $curl = curl_init($this->serverUrl);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER,
                    array("Content-type: application/json"));
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
        //support https without checking certificates 
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $json_response = curl_exec($curl);
        
        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        
        if (!curl_errno($curl)) 
        {
        	$status = sprintf("call to URL %s with status %s, response %s, curl_error %s, curl_errno %s", $this->serverUrl, $http_code, $json_response, curl_error($curl), curl_errno($curl) );
        	SMTLogger::getInstance()->trace( $status, SMTLogger::PINFO);
        	
        	$response = json_decode($json_response, true);
        	if ( $response != NULL && is_array($response) )
        	{
        	    SMTLogger::getInstance()->trace( sprintf("alarm processed: %s", print_r($response, TRUE)) );
        	}        	 
        }
        else 
        {
            $error = sprintf("Error: call to URL %s failed with status %s, response %s, curl_error %s, curl_errno %s", $this->serverUrl, $http_code, $json_response, curl_error($curl), curl_errno($curl) );
            SMTLogger::getInstance()->trace( $error, SMTLogger::ERROR);
            
            $response = json_decode($json_response, true);
            $response = json_decode($json_response, true);
            if ( $response != NULL && is_array($response) )
            {
                SMTLogger::getInstance()->trace( sprintf("alarm processed: %s", print_r($response, TRUE)) );
            }            
        }        
        
        curl_close($curl);        
    }
}
?>