import QtQuick 2.10
import QtQuick.Controls 2.3
import com.viavi.style 1.0

ListView {
    id: table
    boundsBehavior: Flickable.StopAtBounds
    property var colums
    property real colwidthDefault: (width - ((table.colums.count - 1) * table.colSpacing)) / table.colums.count
    property real colwidth: colwidthDefault
    property real rowHeight: 22
    property alias tableheight: table.height
    property color headerColor: Style.tableViewHeaderColor
    property color oddColor: Style.tableViewLineOddColor
    property color evenColor: Style.tableViewLineEvenColor
    property color headerTextColor: Style.tableViewTextHeaderColor
    property real colSpacing: 1
    property bool headerVisible: true

    property var titleFontFamily: Style.cViaviFontFamily
    property var titleElide: Text.ElideNone
    property var titleFontWeight: Font.DemiBold
    property var titleFontSizeMode: Text.FixedSize
    property int titleMinimumPixelSize: 10
    property int titleFontPixelSize: -1

    property var lineFontFamily: Style.cViaviFontFamily
    property var lineElide: Text.ElideNone
    property var lineFontWeight: Font.Normal
    property var lineFontSizeMode: Text.FixedSize
    property int lineMinimumPixelSize: 10
    property int lineFontPixelSize: -1
    property var lineVerticalAlignment: Text.AlignVCenter
    property var lineHorizontalAlignment: Text.AlignHCenter

    header: Row {
        id: hline
        anchors.left: parent.left
        anchors.right: parent.right
        height: (table.headerVisible)?(table.rowHeight):(0)
        visible: table.headerVisible
        spacing: table.colSpacing

        Repeater {
            model: table.colums
            delegate:  Rectangle {
                color: table.headerColor
                width: (table.colwidth < 0)?(columnWidth()):(table.colwidth)
                height: parent.height

                Text {
                    anchors.centerIn: parent
                    text: columnTitle()
                    color: table.headerTextColor
                    font.family: table.titleFontFamily
                    elide: table.titleElide
                    font.weight: table.titleFontWeight
                    fontSizeMode: table.titleFontSizeMode
                    minimumPixelSize: table.titleMinimumPixelSize
                    font.pixelSize: table.titleFontPixelSize
                }

                Rectangle {
                    anchors.bottom: parent.bottom
                    anchors.left: parent.left
                    anchors.right: parent.right
                    color: "white"
                    height: table.spacing
                }
            }
        }
    }

    delegate: Row {
        id: line
        anchors.left: parent.left
        anchors.right: parent.right
        height: table.rowHeight
        spacing: table.colSpacing
        property int linedata: index
        property color rowcolor: (index % 2 == 0)?(table.oddColor):(table.evenColor)

        Repeater {
            model: table.colums

            property bool icon: false
            delegate: Rectangle {
                id: datarow
                color: line.rowcolor
                width: (table.colwidth < 0)?(columnWidth()):(table.colwidth)
                height: parent.height
                clip: true
                Text {
                    anchors.fill: parent
                    text: columnValue(table.model, line.linedata)
                    verticalAlignment: table.lineVerticalAlignment
                    horizontalAlignment: table.lineHorizontalAlignment
                    font.family: table.lineFontFamily
                    elide: table.lineElide
                    font.weight: table.lineFontWeight
                    fontSizeMode: table.lineFontSizeMode
                    minimumPixelSize: table.lineMinimumPixelSize
                    font.pixelSize: table.lineFontPixelSize
                }

                Image {
                    anchors.centerIn: parent
                    visible: (columnIcon(table.model, line.linedata) !== "")
                    width: height
                    height: (visible)?(table.rowHeight):(0)
                    source: columnIcon(table.model, line.linedata)
                }
            }
        }
    }
}
