"""
Module SCPI_Socket
"""


import socket
import sys

#### Class definition #####
class SCPI_Socket:
        """SCPI socket definition for JDSU E-OTDR"""

        def __init__(self,Host,Port) :
                self.mysocket = socket.socket(socket.AF_INET,socket.SOCK_STREAM)
                self.mysocket.settimeout(20)
                try:
                        self.mysocket.connect((Host,Port))
                except:
                        sys.exit("Can't connect to %s at port %s"%(Host,Port))
                self.debug = 0

        def close(self) :
                self.mysocket.close()

        def __print__ (self,string_to_print):
                if (self.debug == 1):
                        print (string_to_print)

        def debug_level (self,debug):
                self.debug = debug

        def __dprint__ (self,string_to_print):
                if (self.debug == 1):
                        print (string_to_print)

        def __check_status__(self,command):
                returnStatus = False

                if (sys.version_info < (3,0,0)):
                        self.mysocket.send("*esr?\r\n")
                        status = self.mysocket.recv(Max_SCPI_Buffer_Size)
                else:
                        self.mysocket.send(bytes("*esr?\r\n",'ascii'))
                        status = self.mysocket.recv(Max_SCPI_Buffer_Size)
                        status = str(status,'ascii')
                self.__dprint__ ("Event register status  : %s"%(status[:-1]))
                if (status == "0\n"):
                        self.__dprint__ ("No Error")
                        returnStatus = True
                elif (status == "16\n"):
                        print ("Execution Error with command : %s"%(command))
                elif (status == "32\n"):
                        print ("Instruction Error with command : %s"%(command))
                else :
                        print ("Unknown Error with command : %s"%(command))


                return returnStatus

        def send(self,command) :
                """ Send a SCPI command and check the ESR egister"""
                self.__dprint__("Send command %s"%command)
                command_ext = command + "\r\n"
                if (sys.version_info < (3,0,0)):
                        self.mysocket.send(command_ext)
                else:
                        self.mysocket.send(bytes(command_ext,'ascii'))

                return self.__check_status__(command)

        def query(self,command) :
                """ Send a SCPI query, check the ESR egister and return the query result"""
                self.__dprint__("Query %s"%command)
                command = command + "\r\n"
                if (sys.version_info < (3,0,0)):
                        self.mysocket.send(command)
                else :
                        self.mysocket.send(bytes(command,'ascii'))

                try:
                        if (sys.version_info < (3,0,0)):
                                answer = self.mysocket.recv(Max_SCPI_Buffer_Size)
                        else :
                                answer = self.mysocket.recv(Max_SCPI_Buffer_Size)
                                answer = str(answer,'ascii')
                        self.__check_status__(command)
                        return (answer[:-1]) # To remove "\n"
                except:
                        print (socket.error)
                        self.__check_status__(command)
                        return ""

Max_SCPI_Buffer_Size = 128






