"""
Module that contains schemas for CAA Test Types
"""
from marshmallow import Schema, fields, validates_schema, ValidationError

from .config_schema_common import test_type_factory, config_factory

#pylint: disable=no-self-use


class CAAReflectionVSWR(Schema):
    """
    Schema for the configuration of a CAA ReflectionVSWR test
    """
    test_type = test_type_factory('CAA Reflection VSWR')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAAReflectionReturnLoss(Schema):
    """
    Schema for the configuration of a CAA ReflectionReturnLoss test
    """
    test_type = test_type_factory('CAA Reflection Return Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAADTFVSWR(Schema):
    """
    Schema for the configuration of a CAA DTFVSWR test
    """
    test_type = test_type_factory('CAA DTF VSWR')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAADTFReturnLoss(Schema):
    """
    Schema for the configuration of a CAA DTFReturnLoss test
    """
    test_type = test_type_factory('CAA DTF Return Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAA1PortCableLoss(Schema):
    """
    Schema for the configuration of a CAA 1 Port Cable Loss test
    """
    test_type = test_type_factory('CAA 1 Port Cable Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAACAA1PortPhase(Schema):
    """
    Schema for the configuration of a CAA 1 Port Phase test
    """
    test_type = test_type_factory('CAA 1 Port Phase')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAASmithChart(Schema):
    """
    Schema for the configuration of a CAA SmithChart test
    """
    test_type = test_type_factory('CAA Smith Chart')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAACheckConfigSchema(Schema):
    """
    Schema for the configuration information of a CAA
    Check test
    """

    test_type = test_type_factory('CAA Check')
    config_file = config_factory('/user/caa/internal/StrataSync/')


class RASASweepTunedSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Sweep Tuned Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASASpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAACLR(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAMultiACLR(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Multi Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASASpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASATotalHarmonicDistortion(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Total Harmonic Distortion')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAFieldStrength(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Field Strength')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAAMFMAudioDemodulation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF AM/FM Demodulation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAGatedSweep(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Gated Sweep')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIASpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIASpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIARSSI(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA RSSI')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIAInterferenceFinder(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Interference Finder')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIARadarChart(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Radar Chart')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIAPIMDetectionSingleCarrier(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA PIM Detection Single Carrier')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIAPIMDetectionMultiCarrier(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA PIM Detection Multi Carrier')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentSpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentRSSI(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent RSSI')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentInterferenceFinder(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Interference Finder')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentRadarChart(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Radar Chart')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAFrequencyScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Frequency Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RACustomScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Custom Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Multi Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power vs Time (Frame)')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDPowerVsTimeSlot(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power vs Time (Slot)')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDDataChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Data Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDSubframe(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Subframe')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDTimeAlignmentError(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Time Alignment Error')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDDataAllocationMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Data Allocation Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDCarrierAggregation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Carrier Aggregation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTAIDScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA ID Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTAMultipathProfile(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Multipath Profile')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTAControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTADatagram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Datagram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDFreqTimeErrorVariation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Freq / Time Error Variation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDPowerStatisticsCCDF(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power Statistics CCDF')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Multi Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power vs Time (Frame)')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDPowerVsTimeSlot(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power vs Time (Slot)')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDDataChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Data Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDSubframe(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Subframe')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDTimeAlignmentError(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Time Alignment Error')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDDataAllocationMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Data Allocation Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDCarrierAggregation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Carrier Aggregation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTAIDScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA ID Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTAMultipathProfile(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Multipath Profile')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTAControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTADatagram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Datagram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDFreqTimeErrorVariation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Freq / Time Error Variation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDPowerStatisticsCCDF(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power Statistics CCDF')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRTriggerSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Trigger Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNROccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Multi Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRBeamAnalyzer(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Beam Analyzer')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRCarrierScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Carrier Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRRouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRBeamAvailabilityIndex(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Beam Availability Index')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRFreqTimeErrorVariation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Freq / Time Error Variation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRPowerVsTimeSymbol(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Power vs Time (Symbol)')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Power vs Time (Frame)')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARFInternalPowerMeter(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFPM Internal RF Power Meter')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARFExternalPowerMeter(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFPM External RF Power Meter')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RANSAAnalyzer(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('NSA Analyzer')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RANSAScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('NSA Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RANSARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('NSA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARFoCPRISpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFoCPRI Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARFoCPRISpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFoCPRI Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAEMFSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('EMF Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAEMF5GNRBeamAnalysis(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('EMF 5G NR Beam Analysis')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Multi Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Power vs Time (Frame)')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSPowerVsTimeSlot(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Power vs Time (Slot)')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSConstellation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Constellation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSChannelMapper(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Channel Mapper')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSSubframe(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Subframe')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSTimeAlignmentError(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Time Alignment Error')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTAIDScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA ID Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTAMultipathProfile(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA Multipath Profile')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTAControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSFreqTimeErrorVariation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Freq / Time Error Variation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')


