#!/bin/sh
#
# /etc/init.d/otu-local-mode  --  script to activate/deactivate the local mode itf for an otu

OTU_LOCAL_MODE_PID=/var/run/dhcpd_otu_local.pid
OTU_LOCAL_MODE_ETH=eth1
OUT_LOCAL_MODE_CONF=/etc/dhcp/dhcpd_otu_local.conf

source /usr/lib/otu_functions

do_start()
{
    # if there is no eth1 get out, nothing to do
    if [ "$(cat /proc/net/dev | grep eth1 | wc -l)" != 1 ] ; then
        exit 0
    fi

    [ -f $OTU_LOCAL_MODE_PID ] && do_stop
    logger "Activating local mode"
    ifconfig eth1 192.168.1.1 up > /dev/null 2>&1
    dhcpd -q -cf $OUT_LOCAL_MODE_CONF -pf $OTU_LOCAL_MODE_PID $OTU_LOCAL_MODE_ETH > /dev/null 2>&1
}

do_stop()
{
    logger "Deactivating local mode"
    [ -f $OTU_LOCAL_MODE_PID ] && cat $OTU_LOCAL_MODE_PID | xargs kill -9
    rm -f $OTU_LOCAL_MODE_PID
}

# if this is not otu hw get out
is_cotu_hw
if [ $? -ne 1 ] ; then
   exit 0
fi

case "$1" in
    start)
		do_start
        ;;
    stop)
        do_stop
        ;;
    restart)
        $0 stop
        $0 start
        ;;
    *)
        echo "Usage: otu-local-mode {start|stop|restart}"
        exit 1
        ;;
esac

exit 0

