import QtQuick 2.3
import "Viavi_Colors.js" as VColor

Rectangle {
   id: container

   width: 600
   height: 70

   color: VColor.cViaviColorLightGray2
   
   property int nbButtons: standardButton.visible + realTimeButton.visible
    
   property int buttonWidth: container.height * 1.5
   property int buttonHeight: container.height
   
   property int textSize: 18
   property color original_color : VColor.cViaviColorGray
   
   property bool isEnabled: setup_data.isAvailable
   
   Rectangle {
      anchors.top: parent.top
      anchors.bottom: parent.bottom
      anchors.left: parent.left
      anchors.right: rowButtons.left
      anchors.rightMargin: 2
    
      color: VColor.cViaviColorGray
    
      Text {
         id: configTxt
         
         anchors.fill: parent
         color: VColor.cViaviColorLightGray2
         
         anchors.left: parent.left
         anchors.leftMargin: 10
         anchors.verticalCenter: parent.verticalCenter
         
         text: windows_manager.txtConfigSetupWindow
         verticalAlignment: Text.AlignVCenter
         horizontalAlignment: Text.AlignLeft
         font.pixelSize: 20
         font.italic: true
         wrapMode: Text.Wrap
         
         clip: true
       }
    }
    
   Row {
      id: rowButtons
      
      anchors.top: parent.top
      anchors.bottom: parent.bottom
      anchors.right: parent.right
      
      layoutDirection: Qt.RightToLeft
      
      spacing: 2
      
      Rectangle {
         id: resultButton
         width: buttonWidth
         height: buttonHeight
         
         color: VColor.cViaviColorGray
         
         enabled: !windows_manager.canGoBackOnClick
         opacity: enabled ? ( mouseAreaResultButton.pressed ? 0.8 : 1 ) : 0.4
         visible: true
         
         Text {
             id: textResults
             color: VColor.cViaviColorWhite
             
             anchors.top: parent.top
             anchors.topMargin: 2
             anchors.horizontalCenter: parent.horizontalCenter
             
             text: windows_manager.txtResults
             
             horizontalAlignment: Text.AlignHCenter
             
             font.pixelSize: textSize
             font.bold: mouseAreaResultButton.pressed
             wrapMode: Text.Wrap             
         }
                
         Image {
            source: "/acterna/storage/look-and-feel/generic/icon_popup_view_results.png"
         
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2
            anchors.top: textResults.bottom
            anchors.topMargin: 2
            anchors.horizontalCenter: parent.horizontalCenter
            
            fillMode: Image.PreserveAspectFit
            smooth: true
         }
         
         MouseArea {
            id: mouseAreaResultButton
            
             anchors.fill: parent
             onClicked: {
               setup_data.Wizard_Setup_Apply_Data();
               windows_manager.Close_Setup_Windows(true); //Regular exit when pressed    
             }           
         }
       }
      
      Rectangle {
         id: realTimeButton
         width: buttonWidth
         height: buttonHeight
         color: VColor.cViaviColorGreen
         
         enabled: isEnabled
         opacity: isEnabled ? ( mouseAreaRealTimeButton.pressed ? 0.8 : 1 ) : 0.4
         visible: setup_data.realTimeVisible
          
         Text {
             color: VColor.cViaviColorWhite
             anchors.fill: parent
             text: windows_manager.txtRealTime
             horizontalAlignment: Text.AlignHCenter
             verticalAlignment:  Text.AlignVCenter
             font.pixelSize: textSize
             font.bold: mouseAreaRealTimeButton.pressed
            wrapMode: Text.Wrap              
         }
         
         MouseArea {
            id: mouseAreaRealTimeButton
            
             anchors.fill: parent
             onClicked: {
               setup_data.Wizard_Setup_Apply_Data();
               windows_manager.Start_Real_Time_Acquisition();
             }
         }
      }
		
	   Rectangle {
			id: standardButton
			width: buttonWidth
			height: buttonHeight
			
			color: VColor.cViaviColorGreen
			
			enabled: isEnabled
			opacity: isEnabled ? ( mouseAreaStandardButton.pressed ? 0.8 : 1 ) : 0.4
			visible: setup_data.startAcqVisible
				    
			Text {
			    color: VColor.cViaviColorWhite
			    anchors.fill: parent
			    text: windows_manager.txtStandard
			    horizontalAlignment: Text.AlignHCenter
			    verticalAlignment:  Text.AlignVCenter
			    font.pixelSize: textSize
			    font.bold: mouseAreaStandardButton.pressed
			    wrapMode: Text.Wrap	            
			}
			
			MouseArea {
				id: mouseAreaStandardButton
				
			    anchors.fill: parent
			    onClicked: {
					setup_data.Wizard_Setup_Apply_Data();
					windows_manager.Start_Acquisition();
			    }           
			}
	    }
       
       Rectangle {
         id: configButton
         width: buttonWidth
         height: buttonHeight
         
         color: VColor.cViaviColorGray
         
         enabled: true
         opacity: mouseAreaConfigButton.pressed ? 0.8 : 1
         visible: windows_manager.canGoBack
         
         Text {
             id: textConfigs
             color: VColor.cViaviColorWhite
             
             anchors.top: parent.top
             anchors.topMargin: 2
             anchors.horizontalCenter: parent.horizontalCenter
             
             text: windows_manager.txtConfigs
             
             horizontalAlignment: Text.AlignHCenter
             
             font.pixelSize: textSize
             font.bold: mouseAreaConfigButton.pressed
             wrapMode: Text.Wrap             
         }
                
         Image {
            source: "/acterna/storage/look-and-feel/generic/icon_popup_view_file.png"
         
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2
            anchors.top: textConfigs.bottom
            anchors.topMargin: 2
            anchors.horizontalCenter: parent.horizontalCenter
            
            fillMode: Image.PreserveAspectFit
            smooth: true
         }
         
         MouseArea {
            id: mouseAreaConfigButton
            
             anchors.fill: parent
             onClicked: {
               setup_data.Wizard_Setup_Apply_Data();
               windows_manager.Close_Setup_Windows(false); //Regular exit when pressed    
             }           
         }
       }
	    
	    /*
	    Wizard_Exit_Button {
         id: exitButton
         width: buttonWidth
         height: buttonHeight
         
         enableLongPress: windows_manager.canGoBack
         enableBackOnClick: windows_manager.canGoBackOnClick
         
         color: container.original_color
         textDef: windows_manager.txtExit
         textsize: textSize
         durationLongTimer: 1500
         
         onPressedButton: {
               setup_data.Wizard_Setup_Apply_Data();
               windows_manager.Close_Setup_Windows(true); //Regular exit when pressed            
               }  
         
         onLongPressedButton: {
               setup_data.Wizard_Setup_Apply_Data();
               windows_manager.Close_Setup_Windows(false); // back to the previous page         
               }    
      }	  */
    }	  
}
