import QtQuick 2.3
import "Viavi_Colors.js" as VColor
import libfo 1.0

Rectangle {
   id: container

   color: VColor.cViaviColorWhite
   width: 951
   height: 756

   Rectangle {
        id: title_banner
        width: parent.width
        height: 40
        color: VColor.cViaviColorGray
        anchors.top : parent.top
        
        Text {
            id: txtLoadMsgFile 
            width: parent.width - 40
            height: parent.height
            color: VColor.cViaviColorWhite
            anchors.centerIn: title_banner
            text: windows_manager.txtLoadFileHeader
            
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 18
            wrapMode: Text.Wrap
            }
        }

    Wizard_Load_Conf_Directory_Listview {
        id: listview
        
        enabled: wizard_directory.canLoad;
        
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: title_banner.bottom
        anchors.bottom: buttonSelection.top
    }

   Rectangle {
       id: buttonSelection
       
       width: parent.width
       height: 70
       
       property int buttonWidth: buttonSelection.height * 1.5
       property int buttonHeight: buttonSelection.height
       property int textSize: 18
       property int buttonMargin: 10
       property int nbButtons: windows_manager.canAskAssist ? 3 : 2

       color: VColor.cViaviColorLightGray2

       anchors.bottom: parent.bottom
       
       Rectangle {
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.left: parent.left
         anchors.right: rowButtons.left
         anchors.rightMargin: 2
         
       
         color: VColor.cViaviColorGray
       
          Text {
            id: pathText
            
            anchors.fill: parent
            color: VColor.cViaviColorWhite
            
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            
            text: wizard_directory.pathLoaded
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            font.pixelSize: 20
            font.italic: true
            wrapMode: Text.Wrap
            
            clip: true
          }
       }
       
       Row {
         id: rowButtons
         
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.right: parent.right
         
         layoutDirection: Qt.RightToLeft
         
         spacing: 2
         
         Rectangle {
           id: cancelButton
           width: buttonSelection.buttonWidth
           height: buttonSelection.buttonHeight

           color: VColor.cViaviColorRed
           
           visible: windows_manager.canAskAssist
           opacity: ( mouseAreaCancelButton.pressed ? 0.8 : 1 )
           
           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: windows_manager.txtCancelLoadingFile
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: buttonSelection.textSize
           }

           MouseArea {
               id: mouseAreaCancelButton
               
               anchors.fill: parent
               onClicked: {
                  wizard_directory.Close_Config_Load_Directory(true)
               }
           }
         }
         
         Rectangle {
           id: validButton
           width: buttonSelection.buttonWidth
           height: buttonSelection.buttonHeight
           color: VColor.cViaviColorGray
           enabled: wizard_directory.canLoad;
           
           opacity: wizard_directory.canLoad ? ( mouseAreaValidButton.pressed ? 0.8 : 1 ) : 0.7
           
           visible: listview.current_idx_selected >= 0

           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: windows_manager.txtLoadSelectedFile
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: buttonSelection.textSize
           }

           MouseArea {
               id: mouseAreaValidButton
               
               anchors.fill: parent
               onClicked: {
                  wizard_directory.Set_Selected_Filename_From_Index(listview.current_idx_selected);
                  wizard_directory.Close_Config_Load_Directory(false)
               }
           }
         }
         
         Rectangle {
           id: switchDirButton
           width: buttonSelection.buttonWidth
           height: buttonSelection.buttonHeight
           color: VColor.cViaviColorGray
           
           property bool goUp: true
           property string goUpIconPath: "/acterna/storage/look-and-feel/generic/Wizard_Goto_Parent_Dir.png"
           property string goDownIconPath: "/acterna/storage/look-and-feel/generic/Wizard_Goto_Child_Dir.png"
           
           opacity: mouseAreaSwitchDirButton.pressed ? 0.8 : 1 

            Image {
               source: switchDirButton.goUp ? switchDirButton.goUpIconPath : switchDirButton.goDownIconPath
            
               anchors.fill: parent
               anchors.margins: 4
               
               fillMode: Image.PreserveAspectFit
               smooth: true
            }
           
           MouseArea {
               id: mouseAreaSwitchDirButton
               
               anchors.fill: parent
               
               onClicked: {
                  wizard_directory.Switch_Directory();
                  switchDirButton.goUp = !switchDirButton.goUp;
                  listview.current_idx_selected = 0
               }
           }
         } 
       }
   } 
}
