import QtQuick 2.3
import "Viavi_Colors.js" as VColor
    
Rectangle {
	id: popupContainer
	
	property string textDisplay: ""
	property bool inProgress: false
	
	width: 650
	height: 250
	color: "gainsboro"
	
    border.width: 2
	border.color: "darkgrey"
	
	signal btnClicked()
	
	Text {
		id: popupTxt
		
//		anchors.verticalCenter: parent.verticalCenter
//		anchors.left: spinImage.right
//		anchors.leftMargin: 10
		
		anchors.verticalCenter: spinImage.verticalCenter
		anchors.left: spinImage.right
		anchors.leftMargin: 30
		anchors.right: popupContainer.right
		anchors.rightMargin: 30
		wrapMode: Text.Wrap
		
		text: textDisplay
		font.pixelSize: 25
	}
	
	Image {
		id: spinImage
		source: path_spin_img
		
//		anchors.verticalCenter: parent.verticalCenter
		anchors.top: popupContainer.top
		anchors.topMargin: 60
		
		anchors.left: parent.left
		anchors.leftMargin: 40
		}
	
	RotationAnimation {
		 target: spinImage
		 property: "rotation"
		 from: 0
		 to: 360
		 direction: RotationAnimation.Clockwise
		 duration: 3000
		 loops: Animation.Infinite
		 running: inProgress
	}
	
	Rectangle {
		id: stopBtn 
		color: VColor.cViaviColorRed
		opacity: btnMouseArea.pressed ? 0.8 : 1
		anchors.right: popupContainer.right
		anchors.rightMargin: 10
		anchors.bottom: popupContainer.bottom
		anchors.bottomMargin: 10
		
		width: 140
		height: 70
		
		MouseArea{
			id: btnMouseArea
			anchors.fill: parent
			onClicked: btnClicked()
		}

		Text {
			text: windows_manager.txtCancel
			anchors.centerIn: parent
			font.pixelSize: 20
			color: "white"
		}
	}
	
	
}
    
    