<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otdr;

use app\util\SMTDto;

use app\util\SMTInvalidValueException;

use app\util\SMTUtil;

/**
 * 
 * @author Sylvain Desplat
 *
 */
class SMTOtdrRangeDto extends SMTDto
{
    /**
     * @var float
     */
    protected $rangeKm = 0;
    
    /**
     * @var int[]
     */
    protected $otdrResolutionCmArray = array();    
    
    /**
     * @param float $rangeKm
     */
    public function setRangeKm( $rangeKm )
    {
        if ( !isset($rangeKm) || $rangeKm === NULL || !is_numeric( $rangeKm ) )
        {
        	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "rangeKm", $rangeKm );
        }        
    	$this->rangeKm = floatval($rangeKm);
    }
    
    /**
     * @return float
     */
    public function getRangeKm()
    {
        return $this->rangeKm !== NULL ? floatval($this->rangeKm) : NULL;
    }    
    
	/**
	 * @param int[] $otdrResolutionCmArray
	 */
	public function setOtdrResolutionCmArray( $otdrResolutionCmArray )
	{
		$this->otdrResolutionCmArray = $otdrResolutionCmArray;
	}

	/**
	 * @return int[]
	 */
	public function getOtdrResolutionCmArray()
	{
		return $this->otdrResolutionCmArray;
	}

	/**
	 * @param int $resolutionCm
	 */
	public function addOtdrResolutionCm( $resolutionCm )
	{
	    if ( !isset($resolutionCm) || $resolutionCm === NULL || !SMTUtil::isInt( $resolutionCm ) )
        {
        	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "resolutionCm", $resolutionCm );
        }	     
	    
		array_push( $this->otdrResolutionCmArray, intval($resolutionCm) );
	}	
	
	/**
	 * 
	 * @param app\serviceshelper\otdr\SMTOtdrRangeDto $otdrRange
	 * 
	 * @return boolean
	 */	
	public function compare( $otdrRange )
	{
	    return $this->rangeKm == $otdrRange->rangeKm;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}
?>