<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTResultSetDto;

use app\util\SMTDto;

/**
 * Container of module Dto with configured and detected (optional: only if config!=detection) module Dtos 
 * 
 * @author Sylvain Desplat
 */
class SMTConfDetModuleDto extends SMTDto
{    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTModuleDto',islist='true')
     * @var array app\services\setup\SMTModuleDto
     */
    protected $configuredModules = array();
    
    protected $configuredModuleCount = 0;
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTModuleDto',islist='true')
     * @var array app\services\setup\SMTModuleDto
     */
    protected $detectedModules = array();
    
    protected $detectedModuleCount = 0;
    
    /**
     * Whether there is a difference between the configuration and the detection.
     * By default, there is no difference.
     * @var array
     */
    protected $moduleDifferences = array(FALSE,FALSE,FALSE); //MOD1 MOD2 MOD3

    /**
     * Whether there are tests of monitoring on the OTU
     * 
     * @var boolean
     */    
    protected $monitoringTests = FALSE;
    
    /**
     * Whether module is compatible with detected switch
     *
     * @var boolean
     */
    protected $moduleCompatibleWithSwitch = TRUE;
    
    /**
     * @return integer
     */
    public function getConfiguredModuleCount()
    {
    	return $this->configuredModuleCount;
    }
    
    /**
     * @return integer
     */
    public function getDetectedModuleCount()
    {
    	return $this->detectedModuleCount;
    }
    
    /**
     * @param string $position (MOD1, MOD2, MOD3)
     * @param boolean $moduleDifference
     */
    function setModuleDifference( $position, $moduleDifference )
    {
    	$index = ((int) filter_var($position, FILTER_SANITIZE_NUMBER_INT) - 1);
	    $this->moduleDifferences[$index] = SMTResultSetDto::ToBoolean($moduleDifference);
    }
    
    /**
     * config == detection? pour le module donne
     * @param string $position (MOD1,MOD2, MOD3)
     *
     * @return boolean 
     */
    function isModuleDifference($position)
    {
    	$index = ((int) filter_var($position, FILTER_SANITIZE_NUMBER_INT) -1);
    	return $this->moduleDifferences[$index];
    }    
    
    
    /**
     * config == detection? pour tous les modules
     * 
     * @return boolean
     */
    function hasModuleDifference()
    {
        $difference = FALSE;
        for ($index = 0 ; $index < count($this->moduleDifferences) ; $index++)
        {
            $difference |= $this->moduleDifferences[$index];
        }
    	
    	return $difference;
    }
    
    /**
     *
     * @param boolean monitoringTests
     */
    function setMonitoringTests( $monitoringTests )
    {
    	$this->monitoringTests = $monitoringTests;
    }
    
    /**
     *
     * @return boolean monitoringTests
     */
    function isMonitoringTests()
    {
    	return $this->monitoringTests;
    }

    /**
     *
     * @param boolean moduleCompatibleWithSwitch
     */
    function setModuleCompatibleWithSwitch( $moduleCompatibleWithSwitch)
    {
    	$this->moduleCompatibleWithSwitch= $moduleCompatibleWithSwitch;
    }
    
    /**
     *
     * @return boolean moduleCompatibleWithSwitch
     */
    function isModuleCompatibleWithSwitch()
    {
    	return $this->moduleCompatibleWithSwitch;
    }
    
    /**
     * 
     * @param app\services\setup\SMTModuleDto $module
     */
    function addConfiguredModule( SMTModuleDto $module = NULL )
    {
        if ( $module != NULL )
        {
        	array_push( $this->configuredModules, $module );
        	$this->configuredModuleCount++;
        }
    }
    
    /**
     *
     * @param app\services\setup\SMTModuleDto $module
     */
    function addDetectedModule( SMTModuleDto $module = NULL )
    {
    	if ( $module != NULL )
    	{
    		array_push( $this->detectedModules, $module );
    		$this->detectedModuleCount++;
    	}
    }
    
    /**
     *
     * @return app\services\setup\SMTModuleDto
     */
    function getConfiguredModule($index)
    {
        return ($index < $this->configuredModuleCount)? $this->configuredModules[$index] : NULL;
    }
    
    /**
     * @return app\services\setup\SMTModuleDto
     */
    function getDetectedModule($index)
    {
    	return ($index < $this->detectedModuleCount)? $this->detectedModules[$index] : NULL;
    }
    
    /**
     *
     * @return app\services\setup\SMTModuleDto
     */
    function getConfiguredModuleByPosition($position)
    {
    	$indexModule = -1;
    	for ( $index = 0; $index < count($this->configuredModules) ; $index++ )
    	{
    		if ( strcasecmp($this->configuredModules[$index]->getPosition(), $position ) == 0 )
    		{
    			$indexModule = $index;
    		}
    	}
    	return ($indexModule >= 0)? $this->configuredModules[$indexModule] : NULL;
    }
    
    /**
     * @return app\services\setup\SMTModuleDto
     */
    function getDetectedModuleByPosition($position)
    {
    	$indexModule = -1;
    	for ( $index = 0; $index < count($this->detectedModules) ; $index++ )
    	{
    		if ( strcasecmp($this->detectedModules[$index]->getPosition(), $position ) == 0 )
    		{
    			$indexModule = $index;
    		}
    	}
    	return ($indexModule >= 0)? $this->detectedModules[$indexModule] : NULL;
    }
    
    /**
     * Serialize as Json data the object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }   
}
?>