'''Module that syncs/registers jobmanager reports to/with stratasync
'''
import os
import sys
import logging

from rest_api.products.usc import dbus

log = logging.getLogger(__name__)


USC_SERVICE = "com.jdsu.usc" # starting point for getting Services list (makes this platform independent - com.jdsu.isu / com.jdsu.bert, etc.)
USC_PATH = "/Usc"

PDF_FILES = "*.pdf" # This may need to be platform-dependent, or specify a little more than just 'TESTDATA'
JOB_FILES = "*.job.json" 
 
# 
JOB_MANAGER_SERVICE_NAME = "com.viavisolutions.jobmanager"

FILE_TYPE_NAME_PDF_TESTDATA = "TESTDATA.PDF REPORT"
FILE_TYPE_NAME_JOB_TEMPLATES = "CONFIG.Job Templates" #TBC
FILE_TYPE_NAME_PROCEDURES = "CONFIG.Test Procedures" #TBC

def register_report_path(file_path):
    """
    Function to sync jobmanager reports with stratasync
    """
    proxy_object = get_usc_proxy_object()
    if proxy_object:
        register_service(proxy_object)
        register_path(proxy_object, file_path, PDF_FILES, FILE_TYPE_NAME_PDF_TESTDATA)


def register_procedures_path(file_path):
    """Function to sync job manager test procedures with stratasync
    """
    proxy_object = get_usc_proxy_object()
    if proxy_object:
        register_path(proxy_object, file_path, PDF_FILES, FILE_TYPE_NAME_PROCEDURES)

def register_job_files_path(file_path):
    """Function to sync job manager job files with stratasync
    """
    proxy_object = get_usc_proxy_object()
    if proxy_object:
        register_path(proxy_object, file_path, JOB_FILES, FILE_TYPE_NAME_JOB_TEMPLATES)


def get_usc_proxy_object():
    """
    Gets the Usc proxy object to interact with remote Usc
    """
    if not dbus:
        return None
    try:
        sys_bus = dbus.SystemBus()
    except dbus.DBusException:
        log.warning(sys.exc_info())

    return sys_bus.get_object(USC_SERVICE, USC_PATH)

def register_service(proxy):
    """
    Registers jobmanager service with Usc
    """
    proxy.Register(JOB_MANAGER_SERVICE_NAME)

def register_path(proxy, path, file_name, file_type):
    """
    Registers the rooth path for the reports and the files(reports) to sync
    """
    if not os.path.exists(path):
        os.makedirs(path)
    proxy.Register_Root_Path(path)
    proxy.RegisterFileToSync(path, file_name, file_type, True)
