"""Module containing a function to update the StrataSync info on a Fiber series (4K,2K,1K)
product
"""

from rest_api.products.mts_services.SCPI_Socket import SCPI_Socket

def update_stratasync_info(tech_id, account_id, url):
    """Function to update stratasync information on the Fiber series products (4K,2K,1K)

    Url arguments can optionally begin with `https://` only the hostname will be
    passed to the ctrlpannelsvc

    Args:
        tech_id (str): the stratasync techId for the technician
        account_id (str): the stratasync account_id for the technician's company
        url (str): the stratasync server url that the technician's company is using
    """
    ISU = SCPI_Socket('127.0.0.1',8000)
    ISU.debug_level(1)

    ISU.send("*rem")
    
    # TECHID
    ISU.send('STSY:TECH "' + str(tech_id) + '"')
    
    #ACCOUNTID
    ISU.send('STSY:ACNT "' + str(account_id) + '"')
    
    #URL
    if "https://eu.stratasync.viavisolutions.com" in url:
        ISU.send('STSY:SRVT EUV')
    elif "https://stratasync.viavisolutions.com" in url:
        ISU.send('STSY:SRVT JDSU')
    else:
        ISU.send('STSY:SRVT NAME')
        urlEdit = url.replace("https://", "https://direct.")
        ISU.send('STSY:SRVN "' + str(urlEdit) + '"')
    
    ISU.close()

    return True
