"""
Module handles sending time update info to
appropriate service to update the system time
"""

from rest_api.products.mts_services.SCPI_Socket import SCPI_Socket
from rest_api.api.info_schemas import DateTimeSchema

def update_local_time(time_value, location):
    """
    Sends a message to the instrument time service to update the local
    time

    Args:
        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]
        location (string): A string representation of the timezone (not used so far)

    Returns:
        True if the request was ack'd
    """

    #print('mts_services\\instrument_time : update_local_time(time_value = {0}, location = {1})'.format(time_value, location))

    ISU = SCPI_Socket('127.0.0.1',8000)
    ISU.debug_level(1)

    ISU.send("*rem")

    # timezone first, because time_value is local time
    try:
        # if location is not a number 'int(location)' will fail
        # MTA sends negative values for EAST of Greenwich, system:tzone expects positive values for EAST of Greenwich
        success = ISU.send('system:tzone "{0}"'.format(str(- int(location))))
    except ValueError:
        # Not a number. Does MTA eventually send a 'true' timezone (eg: 'Europe/Paris') ?
        # Sent as is to ISU
        success = ISU.send('system:tzone "{0}"'.format(location))

    if True: # if success: Disabled for compatibility with existing versions of ISU
        success = ISU.send("system:date %s,%s,%s" % (time_value.year, time_value.month, time_value.day))

    if success:
        success = ISU.send("system:time %s,%s,%s" % (time_value.hour, time_value.minute, time_value.second))
        
    ISU.close()


    return success

#def update_utc_time(time_value):
#    """
#    Sends a message to the instrument time service to update the
#    system utc time

#    Args:
#        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]

#    Returns:
#        True if the request was ack'd
#    """
#    utc_time = utc_from_local_time(time_value)
#    try:
#        utils.cmsend('127.0.0.1', 'chronometer', 'update_time', utc_time, 10)
#    except ClientFactory.ConnectionError:
#        pass
#    return True

#def utc_from_local_time(time_value):
#    """

#    Arguments:
#        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]

#    Returns:
#        time string converted to utc
#    """
#    return time_value.astimezone(pytz.utc).isoformat()
