import os
import json
import datetime
import re

from rest_api.products.usc import dbus
from rest_api.products.usc import asset_info
from rest_api.products.usc import file_sync


def get_sync_list(sync_all):

    if not dbus:
        return {}

    system_bus = dbus.SystemBus()

    proxy_object = file_sync.get_usc_proxy_object()

    file_list = []

    #modules_info.extend(get_modules_info(system_bus, service))
    file_list.extend(proxy_object.MtaGetFilesToSync(sync_all))


    #services = asset_info.get_services_from_usc(system_bus)

    return file_list



def set_sync_list_ack(full_path):
    
    if not dbus:
        return {}

    proxy_object = file_sync.get_usc_proxy_object()

    proxy_object.MtaSetSyncListAck(full_path)


def get_sync_file_type(full_path):

    if not dbus:
        return {}

    system_bus = dbus.SystemBus()

    proxy_object = file_sync.get_usc_proxy_object()

    file_type = proxy_object.MtaGetFileType(full_path)

    return file_type
    
def get_sync_file_metadata(full_path):
    
    if not dbus:
        return {}

    system_bus = dbus.SystemBus()

    proxy_object = file_sync.get_usc_proxy_object()
    
    file_metadata = []
    file_metadata.extend(proxy_object.MtaGetFileMetadata(full_path))
    
    return file_metadata

def format_metadata_result(result):
    if 'pass' in result:
        return 'Pass'
    elif 'fail' in result:
        return 'Fail'
    elif 'marginal' in result:
        return 'Marginal'
    elif 'none' in result:
        return 'None'
    else:
        return result
    

def update_metadata(file_metadata, file_info):
    #Copy the current file_info
    file_info_updated = file_info
    
    sub_info = {}
    
    for metadata in file_metadata:
        #Split metadata String
        metadata_split = metadata.split(':', 1)
        
        #Check all parameters send by USC
        if 'TechnicianId' in metadata_split[0]:
            file_info_updated['techId'] = metadata_split[1]
        elif 'Latitude' in metadata_split[0]:
            file_info_updated['latitude'] = metadata_split[1]
        elif 'Longitude' in metadata_split[0]:
            file_info_updated['longitude'] = metadata_split[1]
        elif 'Info' in metadata_split[0]:
            all_info = re.split(',', metadata_split[1])
            
            for info in all_info:
                info_split = info.split('=', 1)
                if 'result' in info_split[0]:
                    file_info_updated['result'] = format_metadata_result(info_split[1])
                elif 'wo' in info_split[0]:
                    file_info_updated['workOrderId'] = info_split[1]
                elif 'workflowId' in info_split[0]:
                    file_info_updated['workflowId'] = info_split[1]
                elif any(info_split[0]):
                    sub_info[info_split[0]] = info_split[1]
                    
    file_info_updated['info'] = sub_info
                    
    return file_info_updated

def get_sync_file_info(filepath, base_dir):
    
    full_path = os.path.join(base_dir, filepath)
    fstats = os.stat(full_path)
    
    file_name = os.path.basename(full_path)
    
    file_type = get_sync_file_type(full_path)
    
    file_metadata = get_sync_file_metadata(full_path)

    if (file_type == ''):
        file_type = 'MISC.File'
        
    creation_time = int(round(fstats.st_ctime*1000))
    modified_time = int(round(fstats.st_mtime*1000))
    
    ct_iso = datetime.datetime.utcfromtimestamp(fstats.st_ctime).isoformat() + "+00:00"
    md_iso = datetime.datetime.utcfromtimestamp(fstats.st_mtime).isoformat() + "+00:00"

    file_info = {
            "name": file_name,
            "fileUri": "/" + filepath,
            "type": file_type,
            #"format": '',
            "creationTime": ct_iso,
            "modifiedTime": md_iso,
            #"latitude": 0,
            #"longitude": 0,
            "fileSize": fstats.st_size,
            #"workflowId": 0,
            #"workOrderId": '',
            #"projectId": 0,
            #"result": '',
            #"location": '',
            #"moduleId": '',
            #"moduleType": '',
            #"techId": '',
            #"info": {},
            #"overwrite": true
            #"segments": 0,
        }
    
    file_info_updated = update_metadata(file_metadata, file_info)

    return file_info_updated


