"""
Module handles sending location info to
appropriate service to update the instrument location
"""

from rest_api.products.mts_services.SCPI_Socket import SCPI_Socket
from rest_api.api.info_schemas import LocationSchema

def update_location(geolocation):
    """
    Sends a message to the instrument location service to update the
    location

    Args:
        latitude
        longitude
        altitude

    Returns:
        True if the request was ack'd
    """

    #Dic_Isu_Set_Position ( \REEL[ -90 : 90 ],   // Latitude
    #                    \REEL[ -180 : 180 ], // Longitude
    #                    \ENTIER32,           // Qualite "Fix": 0 si pas de position,  > 0 si position disponible
    #                    \ENTIER32,           // Timestamp GPS ( en secondes depuis Unix EPOCH)
    #                    \ENTIER32 );         // Duree de validite en secondes

    latitude = geolocation['latitude']
    longitude = geolocation['longitude']
    timestamp = geolocation['timestamp']
    altitude = geolocation['altitude']
    accuracy = geolocation['accuracy']

    print('mts_services\\instrument_location : update_location(geolocation)')

    ISU = SCPI_Socket('127.0.0.1',8000)
    ISU.debug_level(1)


    # timestamp provided in ms since 1970-1-1
    ISU.send("*rem")
    success = ISU.send("process:gps:setposition %s,%s,%s,%s,%s" %(latitude, longitude, accuracy, int(timestamp / 1000), 3600))
    
    ISU.close()


    return True
