"""Module containing code to connect a 5800 to the smart access anywhere server
The main function is create_code, which returns an ACCESS_ANYWHERE namedtupple
"""
import subprocess

from rest_api.products.access_anywhere import AccessAnywhere

ANYWHERE_FILE_CODE = "/tmp/anywhere.nbr"
ANYWHERE_CONNECT_CMD = "/usr/bin/mts_connection_script.sh CONNECT"

def create_code(servername):
    """Function to send a request to smart access anywhere ctrlpanelsvc to
       establish a connection to the smart access anywhere server.

    args:
        servername: hostname/address of clientmgr (usually '127.0.0.1')
    returns:
        named tuple:
            connectStatus: True if connected, False otherwise
            accessCode: If connection established returns code for SAA access,
                otherwise None is returned
            hasIpAddress: True if the instrument has an IP address or is in static mode,
                False otherwise
    """
    
    rc = None
    with subprocess.Popen( ANYWHERE_CONNECT_CMD, shell=True) as exec:
        while rc is None:
            rc = exec.poll()
            
    if rc == 0:
        f = open(ANYWHERE_FILE_CODE,"r")
        access_code = f.readline()
        f.close()

        access_anywhere = AccessAnywhere(
            accessCode=access_code,
            connectStatus=True,
            hasIpAddress=True,
            errorMessage=''
            )
    else:
        access_anywhere = AccessAnywhere(
            accessCode='0000000',
            connectStatus=False,
            hasIpAddress=True,
            errorMessage='Invalid access code'
            )
    
    return access_anywhere
