"""Module containing api configurations specific to
   T-BERD/MTS-4000 V2, T-BERD/MTS-2000 V2, SmartOTDR instrument family
   ** with Job Manager feature enabled **
"""
import logging

from rest_api.products import fiber_base

from rest_api.products.usc import asset_info

from rest_api.products.mts_services import update_asset_info


log = logging.getLogger(__name__)

class ProductSpecific(fiber_base.ProductSpecific):
    """Class for T-BERD/MTS-4kv2 / 2kv2 / SmartOTDR specific functions
       ** with Job Manager feature enabled **
    """

    @staticmethod
    def make_instrument_info():
        info_version = {'infoVersion':1}

        __version__ = '1.11.0' # Should we align this with latest Yocto project tag?
        __files_api_version__ = 1
        __job_manager_api_version__ = 1
        __location_api_version__ = 1
        __datetime_api_version__ = 1

        __job_manager_api_version__ = 1

        # Experiment overriding api_support per product here
        api_support = {
            'apiSupport': [
                {
                    'name': 'datetime',
                    'versions': [__datetime_api_version__]
                },
                {
                    'name': 'location',
                    'versions': [__location_api_version__]
                },
                {
                    'name': 'techinfo',
                    'versions': [1]
                },
                {
                    'name': 'filemgr',
                    'versions': [__files_api_version__]
                },
                {
                    'name': 'syncfiles',
                    'versions': [1]
                },
                {
                    'name': 'signature',
                    'versions': [__files_api_version__]
                },
                {
                    'name': 'testdata',
                    'versions': [__files_api_version__]
                },
                {
                    'name': 'jobmanager',
                    'versions': [__job_manager_api_version__]
                },
                {
                    'name': 'saa',
                    'versions': [1]
                }
                #{
                    #'name': 'options',
                    #'versions': [1] 
                #}
            ]
        }


        instrument_info = super(ProductSpecific, ProductSpecific).make_instrument_info()

        asset_info_usc = asset_info.make_asset_info()
        instrument_info['assetInfo'] = update_asset_info.update_asset_info(asset_info_usc)

        instrument_info.update(info_version)
        instrument_info.update(api_support)

        log.debug('## make_instrument_info: version                 = %s', __version__)
        log.debug('## make_instrument_info: job_manager_api_version = %s', __job_manager_api_version__)
        log.debug('## make_instrument_info: files_api_version       = %s', __files_api_version__)
        log.debug('## make_instrument_info: location_api_version    = %s', __location_api_version__)
        log.debug('## make_instrument_info: datetime_api_version    = %s', __datetime_api_version__)
        log.debug('## make_instrument_info: api_support: %s', api_support)

        return instrument_info
