"""
Module that contains schemas for CAA Test Types
"""
from marshmallow import Schema, fields, validates_schema, ValidationError

from .config_schema_common import test_type_factory, config_factory

#pylint: disable=no-self-use


class CAAReflectionVSWR(Schema):
    """
    Schema for the configuration of a CAA ReflectionVSWR test
    """
    test_type = test_type_factory('CAA Reflection VSWR')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAAReflectionReturnLoss(Schema):
    """
    Schema for the configuration of a CAA ReflectionReturnLoss test
    """
    test_type = test_type_factory('CAA Reflection Return Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAADTFVSWR(Schema):
    """
    Schema for the configuration of a CAA DTFVSWR test
    """
    test_type = test_type_factory('CAA DTF VSWR')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAADTFReturnLoss(Schema):
    """
    Schema for the configuration of a CAA DTFReturnLoss test
    """
    test_type = test_type_factory('CAA DTF Return Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAA1PortCableLoss(Schema):
    """
    Schema for the configuration of a CAA 1 Port Cable Loss test
    """
    test_type = test_type_factory('CAA 1 Port Cable Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAACAA1PortPhase(Schema):
    """
    Schema for the configuration of a CAA 1 Port Phase test
    """
    test_type = test_type_factory('CAA 1 Port Phase')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAASmithChart(Schema):
    """
    Schema for the configuration of a CAA SmithChart test
    """
    test_type = test_type_factory('CAA Smith Chart')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAACheckConfigSchema(Schema):
    """
    Schema for the configuration information of a CAA
    Check test
    """

    test_type = test_type_factory('CAA Check')
    config_file = config_factory('/user/caa/internal/StrataSync/')


class RASASweepTunedSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Sweep Tuned Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASAChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASAOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASASpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASAAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASAMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASASpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASATotalHarmonicDistortion(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Total Harmonic Distortion')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASAFieldStrength(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Field Strength')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASAAMFMAudioDemodulation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF AM/FM Demodulation')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASAGatedSweep(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Gated Sweep')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RASARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAIASpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAIASpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAIARSSI(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA RSSI')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAIAInterferenceFinder(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Interference Finder')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAIARadarChart(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Radar Chart')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAIAPIMDetectionSingleCarrier(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA PIM Detection Single Carrier')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAIAPIMDetectionMultiCarrier(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA PIM Detection Multi Carrier')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARtSAPersistentSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARtSAPersistentSpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARtSAPersistentRSSI(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent RSSI')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARtSAPersistentInterferenceFinder(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Interference Finder')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARtSAPersistentRadarChart(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Radar Chart')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RAFrequencyScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Frequency Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RACustomScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Custom Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power vs Time (Frame)')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDPowerVsTimeSlot(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power vs Time (Slot)')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDDataChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Data Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDSubframe(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Subframe')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDTimeAlignmentError(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Time Alignment Error')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDDataAllocationMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Data Allocation Map')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDCarrierAggregation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Carrier Aggregation')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDOTAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDOTAIDScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA ID Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDOTAMultipathProfile(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Multipath Profile')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDOTAControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDOTADatagram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Datagram')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDOTARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTETDDPowerStatisticsCCDF(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power Statistics CCDF')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power vs Time (Frame)')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDPowerVsTimeSlot(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power vs Time (Slot)')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDDataChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Data Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDSubframe(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Subframe')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDTimeAlignmentError(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Time Alignment Error')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDDataAllocationMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Data Allocation Map')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDCarrierAggregation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Carrier Aggregation')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDOTAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDOTAIDScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA ID Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDOTAMultipathProfile(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Multipath Profile')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDOTAControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDOTADatagram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Datagram')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDOTARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RALTEFDDPowerStatisticsCCDF(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power Statistics CCDF')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRTriggerSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Trigger Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNROccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRBeamAnalyzer(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Beam Analyzer')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRCarrierScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Carrier Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRRouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRBeamAvailabilityIndex(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Beam Availability Index')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRPowerVsTimeSymbol(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Power vs Time (Symbol)')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RA5GNRPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Power vs Time (Frame)')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARFInternalPowerMeter(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFPM Internal RF Power Meter')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARFExternalPowerMeter(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFPM External RF Power Meter')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARFoCPRISpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFoCPRI Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')

class RARFoCPRISpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFoCPRI Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/StrataSync/')



