"""Module containing common components for config schemas

Primarily field factory functions to create a parameritized field and
the ConfigBase class
"""

from marshmallow import fields
from marshmallow.validate import Equal
from marshmallow_oneofschema import OneOfSchema

def test_type_factory(test_type_str):
    """Function to create a test type field based on a string input

    Args:
        test_type_str (string): the string that will be required input for
            this field
    """
    test_type = fields.Str(validate=Equal(test_type_str,
                                          error='test type mismatch error'),
                           required=True,
                           load_from='testType',
                           dump_to='testType',
                           description='the type of the test')
    return test_type

def config_factory(ui_path_hint):
    """Function to create a config file field containing

    Args:
        ui_path_hint (str): a path hint for the job manager web app to use as the base path
    """
    return fields.Str(
        required=False,
        load_from='configFile',
        dump_to='configFile',
        x_uiPathHint=ui_path_hint,
        description=(
            'the config or project file that needs to be loaded for the test at launch'
        )
    )

class ConfigBase(OneOfSchema):
    """
    Polymorphic mapping for different ConfigSchemas
    """
    type_field = 'testType'
    type_field_remove = False

    def get_obj_type(self, obj):
        if not 'test_type' in obj:
            return None
        return obj['test_type']
