"""Module containing Marshmallow Schemas for info endpoints

Primarily used for deserializing data from the mobile app concerning date and
location
"""

from marshmallow import Schema, fields

class DateTimeSchema(Schema):
    """
    Schema for date and time configuration for the instrument

    """
    time_value = fields.DateTime(required=True,
                                 load_from='timeValue',
                                 dump_to='timeValue',
                                 format="iso8601",
                                 description='ISO 8601 UTC date/time string, \
                                              e.g. 2016-07-21T15:56:00-07:00')
    location = fields.Str(required=True,
                          load_from='location',
                          dump_to='location',
                          description='location of current timezone')

class LocationSchema(Schema):
    """
    Schema for location configuration for the instrument
    """
    latitude = fields.Decimal(
        required=True,
        load_from='latitude',
        dump_to='latitude',
        description='Latitude'
    )

    longitude = fields.Decimal(
        required=True,
        load_from='longitude',
        dump_to='longitude',
        description='Longitude'
    )

    timestamp = fields.Integer(
        required=True,
        load_from='timestamp',
        dump_to='timestamp',
        description='Timestamp of when the location information was sent'
    )

    accuracy = fields.Decimal(
        required=True,
        load_from='accuracy',
        dump_to='accuracy',
        description='Location accuracy metric'
    )

    altitude = fields.Decimal(
        required=True,
        load_from='altitude',
        dump_to='altitude',
        description='Altitude'
    )

    altitude_accuracy = fields.Decimal(
        required=False,
        allow_none=True,
        load_from='altitudeAccuracy',
        dump_to='altitudeAccuracy',
        description='Altitude accuracy metric',
        missing=0
    )
