

ABRIDGMENTS = [
    ("GlobalVerdict", "GlobalVD"),
    ("Hardware", "HW"),
    ("UnitA", "UA"),
    ("UnitB", "UB"),
    ("LastCalibrationDate", "LCAD"),
    ("ModelName", "MN"),
    ("SerialNumber", "SN"),
    ("JsonVersion", "JV"),
    ("LastChangeDate", "LCD"),
    ("Measurement", "MEAS"),
    ("Identifiers", "IDS"),
    ("Length", "LEN"),
    ("Results", "RES"),
    ("Wavelength", "WA"),
    ("TestDateTime", "TDT"),
]


_MAIN_SCHEMA = {
    "Type": "JsonLite",
    "GlobalVerdict": "$.tests.0.results.status",
    "Hardware": {
        "UnitA": {
            "LastCalibrationDate": "$.assetInfo.calibrationDate",
            "ModelName": "$.assetInfo.model",
            "SerialNumber": "$.assetInfo.uniqueId"
        },
        "UnitB": {
            "LastCalibrationDate": "",
            "ModelName": "",
            "SerialNumber": ""
        }
    },
    "Identification": {
        "JobId": "$.workflow.workOrderId"
    },
    "JsonVersion": "1.0",
    "LastChangeDate": "",
    "TestDateTime": "$.tests.0.results.testTime",
}


_TEST_SCHEMA = {
    "Identifiers": "",
    "DistanceUnits": "$.tests.{}.results.data.otdrResults.distanceUnits",
}


_RESULT_SCHEMA = {
    "Status": "$.tests.{}.results.data.otdrResults.measuredResults.{}.status",
    "Length": "$.tests.{}.results.data.otdrResults.measuredResults.{}.fiberLength",
    "Loss": "$.tests.{}.results.data.otdrResults.measuredResults.{}.linkLossdB",
    "Orl": "$.tests.{}.results.data.otdrResults.measuredResults.{}.linkOrldB",
    "Wavelength": "$.tests.{}.results.data.otdrResults.measuredResults.{}.wavelengthNm",
}


_EVENT_SCHEMA = {
    "Distance": "$.tests.{}.results.data.otdrResults.measuredResults.{}.events.{}.distance",
    "Loss": "$.tests.{}.results.data.otdrResults.measuredResults.{}.events.{}.lossdB",
    "Reflectance": "$.tests.{}.results.data.otdrResults.measuredResults.{}.events.{}.reflectancedB",
    "Slope": "$.tests.{}.results.data.otdrResults.measuredResults.{}.events.{}.slopedB"
}


SCHEMAS = {
    'main_schema': _MAIN_SCHEMA,
    'test_schema': _TEST_SCHEMA,
    'result_schema': _RESULT_SCHEMA,
    'event_schema': _EVENT_SCHEMA
}

