

ABRIDGMENTS = [
    ("GlobalVerdict", "GlobalVD"),
    ("Hardware", "HW"),
    ("UnitA", "UA"),
    ("UnitB", "UB"),
    ("LastCalibrationDate", "LCAD"),
    ("ModelName", "MN"),
    ("SerialNumber", "SN"),
    ("JsonVersion", "JV"),
    ("LastChangeDate", "LCD"),
    ("Measurement", "MEAS"),
    ("Identifiers", "IDS"),
    ("Length", "LEN"),
    ("Results", "RES"),
    ("LossAB", "LAB"),
    ("LossBA", "LBA"),
    ("OrlA", "OrlA"),
    ("OrlB", "OrlB"),
    ("Wavelength", "WA"),
    ("TestDateTime", "TDT"),
    ("ReferenceDateTime", "RDT")
]


_MAIN_SCHEMA = {
    "Type": "JsonLite",
    "GlobalVerdict": "$.tests.0.results.status",
    "Hardware": {
        "UnitA": {
            "LastCalibrationDate": "$.assetInfo.calibrationDate",
            "ModelName": "$.assetInfo.model",
            "SerialNumber": "$.assetInfo.uniqueId"
        },
        "UnitB": {
            "LastCalibrationDate": "",
            "ModelName": "",
            "SerialNumber": ""
        }
    },
    "Identification": {
        "JobId": "$.workflow.workOrderId"
    },
    "JsonVersion": "1.0",
    "LastChangeDate": "",
    "ReferenceDateTime": "$.tests.0.results.referenceTime",
    "TestDateTime": "$.tests.0.results.testTime"
}


_TEST_SCHEMA = {
    "Identifiers": "",
    "Length": "$.tests.{}.results.data.fiberLengthM",
}


_RESULT_SCHEMA = {
    "LossAB": "$.tests.{}.results.data.measuredResults.{}.linkLossAtoBdB",
    "OrlA": "$.tests.{}.results.data.measuredResults.{}.linkOrlAdB",
    "LossBA": "$.tests.{}.results.data.measuredResults.{}.linkLossBtoAdB",
    "OrlB": "$.tests.{}.results.data.measuredResults.{}.linkOrlBdB",
    "Wavelength": "$.tests.{}.results.data.measuredResults.{}.wavelengthNm"
}


SCHEMAS = {
    'main_schema': _MAIN_SCHEMA,
    'test_schema': _TEST_SCHEMA,
    'result_schema': _RESULT_SCHEMA
}

