
from json import loads
from jsonpath import jsonpath


class CdmObject:
    def __init__(self, cdm_data):
        self.__data = {}

        if isinstance(cdm_data, str):
            self.__data = loads(cdm_data)

        test_type_path = "$.tests.0.type"   # all tests have the same type, so we extract it from the first one
        self.__test_type = self.get_content(test_type_path, out_type=str)

        tests_path = "$.tests"
        self.__tests = self.get_content(tests_path, out_type=list)

        self.__tests_number = len(self.__tests)

    def get_content(self, path, out_type=None):
        data = jsonpath(self.__data, path)

        if isinstance(data, list) and (len(data) == 1):
            return data[0] if out_type is None else out_type(data[0])

        return out_type if out_type is None else out_type()

    def get_mesured_results(self, test_index):
        if self.test_type == "OTDR":
            results_path = "$.tests.{}.results.data.otdrResults.measuredResults"
        else:
            results_path = "$.tests.{}.results.data.measuredResults"

        return self.get_content(results_path.format(test_index), out_type=list)

    def get_events(self, test_index, result_index):
        if self.test_type == "OTDR":
            events_path = "$.tests.{}.results.data.otdrResults.measuredResults.{}.events"
        else:
            events_path = ""

        return self.get_content(events_path.format(test_index, result_index), out_type=list)

    @property
    def test_type(self):
        return self.__test_type

    @property
    def tests_number(self):
        return self.__tests_number

    def get_cable_id(self, test_index):
        if self.test_type == "OTDR":
            cable_id_path = "$.tests.{}.configuration.otdrSettings.fiber.cableId"
        else:
            cable_id_path = "$.tests.{}.configuration.fiber.cableId"

        return self.get_content(cable_id_path.format(test_index), out_type=str)

    def get_fiber_id(self, test_index):
        if self.test_type == "OTDR":
            fiber_id_path = "$.tests.{}.configuration.otdrSettings.fiber.fiberId"
        else:
            fiber_id_path = "$.tests.{}.configuration.fiber.fiberId"

        return self.get_content(fiber_id_path.format(test_index), out_type=str)

    def get_fiber_number(self, test_index):
        if self.test_type == "OTDR":
            fiber_number_path = "$.tests.{}.configuration.otdrSettings.fiber.number"
        else:
            fiber_number_path = "$.tests.{}.configuration.fiber.number"

        return self.get_content(fiber_number_path.format(test_index), out_type=int)





