'''
Define all wrapper
JDSU
Fabien Proriol
GPLv3
'''


def E():
    if "session" in __builtins__:
        return __builtins__["session"]
    else:
        return None


def O():
    if "output" in __builtins__:
        return __builtins__["output"]
    else:
        return None


def I():
    if "cinput" in __builtins__:
        return __builtins__["cinput"]
    else:
        return None


def P():
    if "projects" in __builtins__:
        return __builtins__["projects"]
    else:
        return None

def Log(l):
    if "logger" in __builtins__:
        __builtins__["logger"].log(l)

def CONST(name, default):
    if "environment" in __builtins__:
        return __builtins__["environment"].value(name,default)
    else:
        return default


def print_default(*args, **kwargs):
    O().print_default(*args, **kwargs)


def print_info(*args, **kwargs):
    O().print_info(*args, **kwargs)


def print_error(*args, **kwargs):
    O().print_error(*args, **kwargs)


def print_help(*args, **kwargs):
    O().print_help(*args, **kwargs)


def print_ok(*args, **kwargs):
    O().print_ok(*args, **kwargs)


def env(*args, **kwargs):
    if "environment" in __builtins__:
        return __builtins__["environment"](*args, **kwargs)
    else:
        return ""


'''
Define Decorators
'''


def EVENT(evname):
    def decorator(fc):
        __builtins__["projects"][fc.__module__].AddEvent(
            evname,
            fc.__module__,
            fc.__name__)
        return fc
    return decorator



def COMMAND(commandname, params={}):
    def decorator(fc):
        __builtins__["cinput"].add_command(commandname, fc)
        fc.parameters = params
        return fc
    return decorator



PYTHON3_EVM_VERSION = "1.1"
