#/bin/bash


######################################
function Usage()
    {
    echo `basename $0`" <BOOT.bin>"
    exit 1
    } 
######################################

[ -z $1 ] && Usage

UBOOT=$1
    
if [ ! -f "$UBOOT" ]
    then
    echo "ERROR : "$UBOOT" not found"
    exit 1
    fi

if [ -L "$UBOOT" ]
    then
    echo "ERROR : "$UBOOT" is a link"
    exit 1
    fi


MTD_UBOOT=`cat /proc/mtd | grep spi0.0 | awk -F":" '{ print $1 }'`

if [ -z "$MTD_UBOOT" ]
    then
    echo "ERROR : Unable to find Uboot mtd"
    exit 1
    fi



UBOOT_SIZE=$(ls -l $UBOOT | awk '{ print $5 }')

MTD_UBOOT_BLK=$(echo $MTD_UBOOT | sed -e 's|mtd|mtdblock|')


dd if=/dev/$MTD_UBOOT_BLK of=/var/volatile/uboot-flashed-red bs=$UBOOT_SIZE count=1
cmp $UBOOT /var/volatile/uboot-flashed-red
RTN=$?
rm -f /var/volatile/uboot-flashed-red
if [ $RTN == 0 ]
   then
   echo "This Boot is already flashed, nothing to do"
   exit 0
   fi

echo "Writing "$UBOOT
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "!!!!!!!!!!!!!!! DO NOT SWITCH OFF !!!!!!!!!!!!!!!!!!"
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo

flashcp -v $UBOOT /dev/$MTD_UBOOT

if [ $? != 0 ]
    then
    echo "ERROR : Unable to flash uboot"
    exit 1
    fi

echo "Boot successfully updated"

exit 0
