import os
from lxml import etree
from jdsu.cal.calib import *

def filter(release):
    # Check if it's an Optimeter
    cal = cal_get_base_calibration()
    identity = cal.data["Common"].data["Header"].data["Header_Identity"].value()
    if identity != 40:
        # Not Optimeter
        return True
    major = int(release.xpath("content/item[@name='File System']/@version")[0].split(".")[0].replace("V",""))
    minor = int(release.xpath("content/item[@name='File System']/@version")[0].split(".")[1])
    if major < 21:
        print("Downgrade to version File System %i.%i < 21.2 Forbiden"%(major,minor))
        return False
    elif major == 21 and minor < 2:
        print("Downgrade to version File System %i.%i < 21.2 Forbiden"%(major,minor))
        return False

    return True
