#!/bin/bash
#
# This script prepare OTU hardware and do :
#  - Mount SDCard partitions on hardisk and log, manage mount points
#  - Install logrotate otu special rules
#  - Disable tftp if necessary (tftp is required for eotdrv2)
#

source /usr/lib/otu_functions

LOG_PART_RESCUE="/dev/mmcblk1p7"

is_cotu_hw
if [ $? -eq 1 ] ; then
	source /etc/otu/otuparts.sh
	# Prepare the SDCARD and mount any partition we need
	if [ -e $DEV_SDSCARD ] ; then
		mount $DEV_LOG /var/log
		mkdir -p /user/harddisk
		mount $DEV_USER /user/harddisk
	else
		echo "Err : No SDCard found, Otu will not start properly"
	fi

	# Otu use specific logrotate rules prepare them only one time
	if [ -f /etc/logrotate.d/99_otu.logrotate.otu ] ; then
		mv /etc/logrotate.d/99_otu.logrotate.otu /etc/logrotate.d/99_otu.logrotate
		mv /etc/logrotate.d/00_logsystem.logrotate.otu /etc/logrotate.d/00_logsystem.logrotate
	fi

    cat /etc/xinetd.d/inet_tftp | grep disable | grep "no" > /dev/null
    [ $? -eq 0 ] && sed -i "/disable/c\disable = yes" /etc/xinetd.d/inet_tftp

    # EPT #7075 : on OTU we don't want the route local net from eotdrv2 remove it
    grep -q "net.ipv4.conf.eth0.route_localnet=1" /etc/sysctl.conf
    if [ $? -eq 0 ] ; then
		sed -i "/net.ipv4.conf.eth0.route_localnet/d" /etc/sysctl.conf
		sysctl -w net.ipv4.conf.eth0.route_localnet=0
		fi
else
    cat /etc/xinetd.d/inet_tftp | grep disable | grep "yes" > /dev/null
    [ $? -eq 0 ] && sed -i "/disable/c\disable = no" /etc/xinetd.d/inet_tftp
fi
exit 0
