#!/bin/bash
#
# Prepare fs for Otu
#
# This script manage :
#   - /otu directory creation or deletion
#   - Debug mode for not switching part if otu doesn't start properly
#   - Symlink for Otu.ver to /acterna/release/bin/
#   - Ensure ot trusted user are removed in enhanced security mode
#   - Ensure smartotu log file are writable from apache
#

source /usr/lib/otu_functions

# If we are not Otu but /otu directory exists remove it (otu5000 to eotdrv2 conversion by manufacturing)
is_cotu_hw
HW_OTU=$?
is_otu_sw
SW_OTU=$?
[ "${HW_OTU}" == "0" ] && [ "${SW_OTU}" == "0" ] && [ -f /otu ] && rm -rf /otu

# Do the rest only if using otu
quit_if_not_using_otu

# Create /acterna/user directory (temporary we have to remove this directory and use /user instead)
if [ ! -d /acterna/user ] ; then
        mkdir /acterna/user
fi
if [ ! -d /acterna/user/disk ] ; then
        mount --rbind /user /acterna/user
fi

# Create /Otu directory
if [ ! -L /otu ] ;  then
    if [ -d /user/harddisk ] ; then
		mkdir -p /user/harddisk/otu
        ln -s /user/harddisk/otu /otu        
    elif [ -d /user/disk ] && [ "${HW_OTU}" == "0" ] && [ "${SW_OTU}" == "1" ] ; then
		mkdir -p /user/disk/otu
        ln -s /user/disk/otu /otu
    fi
else
	# Enforce link to otu to the harddisk if present
	if [ -d /user/harddisk ] && [ "$(readlink /otu)" != /user/harddisk/otu ] ; then
        rm /otu
        mkdir -p /user/harddisk/otu
        ln -sf /user/harddisk/otu /otu
	fi
	# Enforce /otu removal if harddisk is not present with otu hardware (do not work using flash)
	mountpoint /user/harddisk > /dev/null 2>&1
	HAS_NO_HARDDISK=$?
	if [ "${HAS_NO_HARDDISK}" == "1" ]  && [ "${HW_OTU}" == "1" ] && [ -h /otu ] ; then
	     rm -rf /otu
	fi
fi

# If the file debug exists we don't want to switch partition if Otu doesn't start
[ -f /acterna/storage/otu/debug ] && ! [ -f /otu/release/tmp/first_boot_after_upgrade.tmp ] && otu_confirm_start.sh

# if there is a otu.ver file move it to /etc/acterna/
if [ -f /acterna/release/bin/Otu.ver ] && [ ! -h /acterna/release/bin/Otu.ver ] ; then
	mv /acterna/release/bin/Otu.ver /etc/acterna/Otu.ver
fi

# Create symlink to Otu.ver file if doesn't exist
if [ ! -f /acterna/release/bin/Otu.ver ] && [ -f /etc/acterna/Otu.ver ] ; then
	ln -sf /etc/acterna/Otu.ver /acterna/release/bin/Otu.ver
fi

# In enhance security mode we have to check every boot that users have not been added during an upgrade
if [ "$(/sbin/fw_printenv -n Enhanced_Security)" = "true" ] ; then
    bash /usr/lib/jdsu/scripts/update_user_list.sh "DEL" > /dev/null 2>&1
fi

# Log partition we are using in otu log
if [ -d /otu/log ] ; then
    source /etc/otu/otuparts.sh
    CURRENT_DATE=$(date '+%Y-%m-%d %H:%M:%S.%3N')
    echo "${CURRENT_DATE} : Boot using partition ${CURRENT_PART}" >> /otu/log/boot.log
    if [ -f /proc/device-tree/board/rescue-mode ] && [ $(cat /proc/device-tree/board/rescue-mode) == "yes" ] ; then
        echo "${CURRENT_DATE} : Started in rescue mode" >> /otu/log/boot.log
        # We want to try again to boot normally at next reboot
        otu_confirm_start.sh
    fi
fi

# Temporary : Create log file required for smartotu
touch /var/log/otu_query.log
touch /var/log/smart_otu.log
chown www-data:www-data /var/log/otu_query.log
chown www-data:www-data /var/log/smart_otu.log

exit 0
