#!/bin/bash
#
# otu_rfs_sync		This shell script takes care of starting and stopping
#		otu_rfs_sync.sh (rescue FS synchronization daemon).
#
# chkconfig: 235 58 74
# description: otu_rfs_sync.sh is the rescue filesystem daemon. \
# The synchronization (copy) is done when inotifywait detects a change in a \
# watched file.

source /etc/init.d/functions
source /usr/lib/otu_functions

RETVAL=0
prog="otu_rfs_sync.sh"
lockfile=/var/lock/subsys/$prog
logfile=/var/log/otu_rfs_sync.log

runlevel=$(set -- $(runlevel); eval "echo \$$#" )

WATCHED_FILES_LIST="
/etc/shadow 
/etc/passwd 
/etc/password_removed
/etc/shadow_removed
/etc/hostname
/etc/aliases
/etc/group
/root/.ssh/authorized_keys 
/etc/sysconfig/iptables
/etc/sysconfig/ip6tables
/acterna/storage/share/ssu.conf  
/acterna/storage/otu/calibration/otu.cal
/acterna/storage/otu/communication/media.cfg
/acterna/storage/otu/communication/webservice.cfg
/acterna/storage/otu/communication/port.cfg
/acterna/storage/otu/communication/superv.cfg
/acterna/storage/otu/communication/snmp.cfg
/acterna/storage/otu/communication/modem.cfg
/acterna/storage/otu/communication/sms.cfg
/acterna/storage/otu/communication/tsc.cfg
/acterna/storage/otu/communication/alerte.cfg
/acterna/storage/otu/communication/interface.cfg
/acterna/storage/otu/communication/topaz.cfg
/acterna/storage/isu/config/cotu_license.xml 
/etc/pki/tls/private/smartotu-private.key 
/etc/pki/tls/certs/smartotu-certificate.crt 
/etc/pki/tls/certs/smartotu-certificate-chain.crt
/home/secuser/.ssh/authorized_keys
/home/secuser/.ssh/otu_id_rsa_4096
/home/secuser/.ssh/otu_id_rsa"

start()
{  
    rm $logfile
	echo -n $"Starting $prog: "
	$prog --timeout 1 --type update $WATCHED_FILES_LIST>> $logfile  2>&1 &
    RETVAL=$?
    $prog --timeout 1 --type rename $WATCHED_FILES_LIST>> $logfile  2>&1 &
	RETVAL=$(($RETVAL | $?))
	[ "$RETVAL" = 0 ] && success || failure
	[ "$RETVAL" = 0 ] && touch $lockfile
	echo
	return $RETVAL
}

stop()
{
	echo $"Stopping $prog: "
    
    RETVAL=0
    
    pids=$(ps -eo pid,ppid,cmd | grep $prog | awk '{ if ( $2 == 1 ) {print $1} }')
    pids_count=$(echo $pids | wc -w)
    if [[ $pids_count -lt 1 ]] ; then RETVAL=1; fi
    
    for pid in $pids
    do
      echo "Killing all child process of ppid = $pid"
      pkill -P $pid
      RETVAL=$(($RETVAL | $?))
    done
    
    
	if [ "$RETVAL" != "0" ] ; then
	    failure
	else
		success
	fi
	[ "$RETVAL" = 0 ] && rm -f $lockfile
	echo
}

restart() {
	stop
	start
}


# Ne fait rien si on n'est pas Otu
is_cotu_hw
if [ $? -ne 1 ] ; then
   exit 0
fi

case "$1" in
	start)
		start
		;;
	stop)
		stop
		;;
	restart)
		restart
		;;
	*)
		echo $"Usage: $0 {start|stop|restart}"
		RETVAL=2
esac
exit $RETVAL

