import QtQuick 2.3
import "Viavi_Colors.js" as VColor

Rectangle {
   id: container

   color: VColor.cViaviColorWhite
   anchors.fill: parent
   
   property int current_idx_selected : 0
   
   property int items_margin: 10
   
   // input property
   property string inputTitleText: ""
   property string inputLoadText: "LOAD"
   property string inputCancelText: "CANCEL"
   property string inputDirectoryPath: ""
   
   // input alias
   property alias inputModel: listview.model
   
   signal btnLoadClick( string filePath );

   Rectangle {
      id: title_banner
      width: parent.width
      height: 40
      color: VColor.cViaviColorGray
      anchors.top : parent.top
        
      Text {
	     id: txtLoadMsgFile 
		 width: parent.width / 2
		 height: parent.height
		 color: VColor.cViaviColorWhite
		 anchors.centerIn: title_banner
		 text: inputTitleText
		 verticalAlignment: Text.AlignVCenter
		 horizontalAlignment: Text.AlignLeft
		 font.pixelSize: 20
		 wrapMode: Text.Wrap
      }
   }
  
   ListView {
      id: listview
      spacing: 0
      boundsBehavior: Flickable.StopAtBounds
      
	  anchors.left: parent.left
	  anchors.right: parent.right
	  anchors.top: title_banner.bottom
	  anchors.bottom: buttonSelection.top

      highlightMoveVelocity: -1
      highlightMoveDuration: -1
      
      currentIndex: current_idx_selected

      clip: true
      
      onCurrentIndexChanged: {
         current_idx_selected = currentIndex;
      }

      delegate:  
         Rectangle {
            id: delegateContainer
            width: listview.width
            height: 50
                     
            color: delegateContainer.ListView.isCurrentItem ? VColor.cViaviColorLogoPurple : "transparent"
                     
            Text {      		
               anchors.left : parent.left
               anchors.leftMargin: delegateContainer.ListView.isCurrentItem ? 2 * items_margin : items_margin
            		      
               anchors.verticalCenter: delegateContainer.verticalCenter
               	
               color: delegateContainer.ListView.isCurrentItem ? VColor.cViaviColorWhite : VColor.cViaviColorBlack
                   
               text: modelData
               verticalAlignment: Text.AlignVCenter
   		       font.pixelSize: delegateContainer.ListView.isCurrentItem ? 20 : 16
   			   font.bold: delegateContainer.ListView.isCurrentItem
            }
                     
            Rectangle {
               color: VColor.cViaviColorLightGray2
                
               anchors.bottom: delegateContainer.bottom
               anchors.horizontalCenter: delegateContainer.horizontalCenter
                
               height: 1
               width: delegateContainer.width * 0.90
            }
                     
            MouseArea {
               anchors.fill: parent
               onClicked: {
                  current_idx_selected = index;
               }
            }
         }
   }

   Rectangle {
      id: buttonSelection
       
      width: parent.width
      height: 70
   
      property int buttonWidth: buttonSelection.height * 1.5
      property int buttonHeight: buttonSelection.height
      property int textSize: 20
      property int buttonMargin: 10

      color: VColor.cViaviColorLightGray2

      anchors.bottom: parent.bottom
       
      Rectangle {
         anchors.top: parent.top
         anchors.bottom: parent.bottom
         anchors.left: parent.left
         anchors.right: cancelButton.left
         anchors.rightMargin: 2
         
         color: VColor.cViaviColorGray
       
         Text {
            id: pathText
            
            anchors.fill: parent
            color: VColor.cViaviColorWhite
            
            anchors.left: parent.left
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            
            text: container.inputDirectoryPath
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignLeft
            font.pixelSize: 20
            font.italic: true
            wrapMode: Text.Wrap
            
            clip: true
         }
      }
         
      Rectangle {
         id: cancelButton
         width: buttonSelection.buttonWidth
         height: buttonSelection.buttonHeight

         color: VColor.cViaviColorGray
         
         anchors.right: validButton.left
         anchors.rightMargin: 2
         
         opacity: ( mouseAreaCancelButton.pressed ? 0.8 : 1 )
       
         Text {
            color: VColor.cViaviColorWhite
            anchors.fill: parent
            text: container.inputCancelText
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment:  Text.AlignVCenter
            
            font.pixelSize: mouseAreaCancelButton.pressed ? buttonSelection.textSize + 2 : buttonSelection.textSize
            font.bold: mouseAreaCancelButton.pressed
         }

         MouseArea {
            id: mouseAreaCancelButton
            
            anchors.fill: parent
            onClicked: {
            	container.visible = false;
            }
         }
      }
         
      Rectangle {
         id: validButton
         width: buttonSelection.buttonWidth
         height: buttonSelection.buttonHeight
         color: VColor.cViaviColorGray
         
         anchors.right: buttonSelection.right
       
         opacity: ( mouseAreaValidButton.pressed ? 0.8 : 1 )
       
         visible: true

         Text {
            color: VColor.cViaviColorWhite
            anchors.fill: parent
            text: container.inputLoadText
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment:  Text.AlignVCenter
            font.pixelSize: mouseAreaValidButton.pressed ? buttonSelection.textSize + 2 : buttonSelection.textSize
            font.bold: mouseAreaValidButton.pressed
         }

         MouseArea {
            id: mouseAreaValidButton
           
            anchors.fill: parent
            onClicked: {
               container.visible = false;
               console.log("[Qml] Valid Load File Button clicked");
               btnLoadClick( inputDirectoryPath + inputModel[current_idx_selected] );
            }
         }
      }
   }
}
