<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2018. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otdr;

use app\util\SMTLogger;
use app\util\SMTIOException;

/**
 * Utility class to handle OTDR trace files on OTU file system
 *
 * @author Sylvain Desplat
 */
class SMTUfomFileUtil extends SMTBaseOtdrTraceFileUtil
{
	//last monitoring trace
	const OTU_UFOM_DIR = '/otu/UFOM/';
	const CSV_EXT = '.csv';
	const INFO_EXT = '.info';
	const REF_SOR_EXT = 'REF.sor';
	const SOR_EXT = 'ALARM.sor';
	const UFOM_PREFIX = 'UFOM';
	
	
	/**
	 * Retrieve the name of the current upgrade archive
	 *
	 * @return current upgrade or NULL if none is found
	 */
	private static function getLastFileName($pattern, $last=TRUE)
	{
		$fileName = NULL;
		$count = 0;
		
		//retrieve file name
		$resultArray = glob( $pattern);
		SMTLogger::getInstance()->trace("getLastFileName>> ".$pattern);
		if ( $resultArray != FALSE && !empty( $resultArray ) )
		{
			$upgradeFiles = array();
			foreach ( $resultArray as $file )
			{
				SMTLogger::getInstance()->trace("getLastFileName>> ".$file);
				$upgradeFiles[ filemtime( $file )] = $file;
			}
			if ( $last )
			{
				krsort( $upgradeFiles, SORT_NUMERIC );
			}
			else
			{
				ksort( $upgradeFiles, SORT_NUMERIC );
			}
			$fileName = array_shift($upgradeFiles);
		}
		
		return $fileName;
	}
	
	/**
	 * Return the last ufom generated csv file
	 *
	 * @return string the last ufom csv file generated
	 */
	public static function retrieveUfomLastCsvFile($last=TRUE)
	{
		try
		{
			$csvFileName= self::getLastFileName( self::OTU_UFOM_DIR.self::UFOM_PREFIX.'*'.self::CSV_EXT, $last);
			if ( $csvFileName == NULL )
			{
				SMTLogger::getInstance()->trace("retrieveUfomLastCsvFile>> no csv file found", SMTLogger::ERROR);
			}
			
		}
		catch( \Exception $e )
		{
			SMTLogger::getInstance()->traceException($e);
			throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, $csvFileName);
		}
		return $csvFileName;
	}
	
	
	/**
	 * delete ufom csv File file
	 *
	 */
	public static function deleteUfomCsvFile( $fileName)
	{
		if ( !unlink($fileName) )
		{
			SMTLogger::getInstance()->trace("deleteUfomCsvFile>> file not found ".$fileName, SMTLogger::ERROR);
		}
	}
	
	/**
	 * Return the last ufom alarm sor file
	 *
	 * @return string the last ufom alarm sor file generated
	 */
	public static function retrieveUfomLastSorFile()
	{
		
		try
		{
			$csvFileName= self::getLastFileName( self::OTU_UFOM_DIR.self::UFOM_PREFIX.'*'.self::SOR_EXT );
			if ( $csvFileName == NULL )
			{
				SMTLogger::getInstance()->trace("retrieveUfomLastSorFile>> no alarm sor file found", SMTLogger::ERROR);
			}
		}
		catch( \Exception $e )
		{
			SMTLogger::getInstance()->traceException($e);
			throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, $csvFileName);
		}
		return $csvFileName;
	}
	
	/**
	 * Deletealarm sor file
	 *
	 */
	public static function deleteUfomSorFile( $fileName)
	{
		if ( !unlink($fileName) )
		{
			SMTLogger::getInstance()->trace("deleteUfomSorFile>> file not found ".$fileName, SMTLogger::ERROR);
		}
	}
	
	/**
	 * Return the last ufom ref sor file
	 *
	 * @return string the last ufom ref sor file
	 */
	public static function retrieveUfomRefSorFile()
	{
		try
		{
			$csvFileName= self::getLastFileName( self::OTU_UFOM_DIR.self::UFOM_PREFIX.'*'.self::REF_SOR_EXT );
			if ( $csvFileName == NULL )
			{
				SMTLogger::getInstance()->trace("retrieveUfomRefSorFile>> no ref sor file found", SMTLogger::ERROR);
			}
			
		}
		catch( \Exception $e )
		{
			SMTLogger::getInstance()->traceException($e);
			throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, $csvFileName);
		}
		return $csvFileName;
	}
	
	/**
	 * Return the last ufom debugfile
	 *
	 * @return string the last ufom debugfile
	 */
	public static function retrieveUfomLastDebugFile()
	{
		try
		{
			$csvFileName= self::getLastFileName( self::OTU_UFOM_DIR.self::UFOM_PREFIX.'*'.self::INFO_EXT);
			if ( $csvFileName == NULL )
			{
				SMTLogger::getInstance()->trace("retrieveUfomLastDebugFile>> no debug file found", SMTLogger::ERROR);
			}
			
		}
		catch( \Exception $e )
		{
			SMTLogger::getInstance()->traceException($e);
			throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, $csvFileName);
		}
		return $csvFileName;
	}
	
	/**
	 * delete all Debug Files except latest
	 *
	 */
	public static function deleteUfomDebugFiles()
	{
		$pattern = self::OTU_UFOM_DIR.self::UFOM_PREFIX.'*'.self::INFO_EXT;
		$lastFileName= self::getLastFileName( $pattern, TRUE);
		
		$resultArray = glob( $pattern);
		if ( $resultArray != FALSE && !empty( $resultArray ) )
		{
			$upgradeFiles = array();
			foreach ( $resultArray as $file )
			{
				if ( strcasecmp($file, $lastFileName) != 0 )
				{
					if ( unlink($file) )
					{
						SMTLogger::getInstance()->trace("deleteUfomDebugFiles>> delete file: ".$fileName, SMTLogger::ERROR);
					}
				}
			}
		}
	}
	
}
?>
