<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otau;

use app\parser\SMTOtuSocket;

use app\parser\SMTOtuApi;

/**
 *
 * @author Sylvain Desplat
 *
 */
class SMTMacroSwitchDet extends SMTMacroSwitch
{
    /**
     * 
     * @param app\parser\SMTOtuSocket $socket
     */
    function __construct( SMTOtuSocket $socket )
    {
        parent::__construct($socket);
    }
    
    /**
     * Retrieve the switch GLOB endoded string
     * Used to apply the new config.
     */
    protected function retrieveGlobal()
    {
        $result = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_detect_desc, SMTSwitchManager::MACRO_SWITCH_ID, parent::GLOB ) );
        list( $device, $code, $test ) = explode(',', $result);        
        $this->setSwitchDecoder( parent::GLOB, $code );
        
        // distributor OSX musn't be fetched twice
        $hasDistributor = $this->getSwitchDecoder( parent::GLOB)->hasOSUDistributor();
        $nbOsx = $this->getSwitchDecoder( parent::GLOB)->getOSUCount();
        if ( $hasDistributor && ($nbOsx >= self::OSU_DISTRIBUTOR_INDEX) )
        {
        	$nbOsx = self::OSU_DISTRIBUTOR_INDEX -1 ;
        }
        
        //retrieve OSU if needed: WARNING only retrieve OSU1 and OSU2 in simplified mode
        for ( $osuCount = 1; $osuCount <= $nbOsx; $osuCount++)
        {
            $result = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_detect_desc, SMTSwitchManager::MACRO_SWITCH_ID, parent::OSU.$osuCount ) );
            list( $device, $code, $test ) = explode(',', $result);
            $this->setSwitchDecoder( parent::OSU.$osuCount, $code );
        }
         
        //distributor OSU is at address 31
        if ( $hasDistributor)
        {
        	$result = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_detect_desc, SMTSwitchManager::MACRO_SWITCH_ID, $this->getSwitchDecoder( parent::GLOB)->getOSUDistributor()) );
            list( $device, $code, $test ) = explode(',', $result);
            $this->setSwitchDecoder( parent::OSU_DISTRIBUTOR, $code );
        }        
    }

    /**
     * Retrieve internal switch and build Dto
     *  
     */
    protected function retrieveInternal()
    {
        $result = trim( $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_detect_desc, SMTSwitchManager::MACRO_SWITCH_ID, parent::INTERNAL ) ) );
        if ( $result != "")
        {
            list( $device, $code, $test ) = explode(',', $result);
            $code = trim($code);
            
            if ( $code != "")
            {
                $this->setSwitchDecoder( parent::INTERNAL, $code );        
                $this->serialNumber = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_detect_SerialNum, SMTSwitchManager::MACRO_SWITCH_ID, parent::INTERNAL ) );
            }
        }
    }        
    
    /**
     * Retrieve internal switch and build Dto
     *
     */
    protected function updateOSXSerialNumbers()
    {
    	$result = trim( $this->socket->sendReceive( SMTOtuApi::CMD_switch_detect_Serial_Number_List) );
    	if ( $result != "" )
    	{
    		$serialNumberList = explode(',', $result);
    		if (is_array($serialNumberList) && count($serialNumberList) > 0)
    		{
    			foreach ( $this->switchesDto as &$switchDto)
    			{
    				if ($switchDto->getIndex() == self::OSU_DISTRIBUTOR_INDEX)
    				{
    					$switchDto->setSerialNumber( end($serialNumberList) );
    				}
    				else if ( $switchDto->getIndex() > 0)
    				{
    					$switchDto->setSerialNumber( $serialNumberList[$switchDto->getIndex() - 1] );
    				}
    			}
    		}
    	}
    }
    
    function hasMolexOSU()
    {
    	if ( $this->getSwitchDecoder( self::GLOB) == NULL )
    	{
    		$result = $this->socket->sendReceive( SMTOtuApi::CMD_get_osu_det_type );
    		return strcasecmp('MOLEX', $result) == 0;
    	}
    	
    	return ($this->getSwitchDecoder( self::GLOB) != NULL)? $this->getSwitchDecoder( self::GLOB)->hasMolexOSU(): FALSE;
    }
    
    function hasJdsuOSU()
    {
    	if ( $this->getSwitchDecoder( self::GLOB) == NULL )
    	{
    		$result = $this->socket->sendReceive( SMTOtuApi::CMD_get_osu_det_type );
    		return strcasecmp('JDSU', $result) == 0;
    	}
    	
    	return ($this->getSwitchDecoder( self::GLOB) != NULL)? $this->getSwitchDecoder( self::GLOB)->hasJdsuOSU(): FALSE;
    }
    
    /**
     * Retrieve internal switch and build the switch Dto
     * 
     * @param SMTOtuSocket $socket
     *
     * @return SMTMacroSwitchDet
     */
    static function retrieve( SMTOtuSocket $socket )   
    {
        $macroSwitchDet = new SMTMacroSwitchDet( $socket );
        $macroSwitchDet->retrieveGlobal();
    	$macroSwitchDet->retrieveInternal();
    	$macroSwitchDet->buildSwitchDto( TRUE );
    	$macroSwitchDet->updateOSXSerialNumbers();
    	
    	return $macroSwitchDet;
    }    
}
?>