<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;

class SMTConfSmsDto extends SMTRwDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTSmsDto',islist='true')
     * @var array app\services\setup\SMTSmsDto
     */
    protected $smsArray = array();
    	
    protected $modemAvailable = FALSE;
    
    /**
     * Whether modem option is available
     * @var boolean
     */
    protected $smsOptionValid = FALSE;
    
    /**
     * @var string
     */
    protected $modemType = NULL;
    
	protected $active = FALSE;		

	const MODEM_GSM  = "GSM";
	const MODEM_PSTN = "PSTN";
	const MODEM_ISDN = "ISDN";
	
	/**
	 * @param string
	 */
	public function setModemType( $modemType )
	{
		$this->modemType = $modemType;
	}
	
	/**
	 * @return string
	 */
	public function getModemType()
	{
		return $this->modemType;
	}	
	
	/**
	 * @param boolean $valid
	 */
	public function setSmsOption ( $smsOptionValid )
	{
		$this->smsOptionValid = $smsOptionValid;
	}
	
	/**
	 * @return boolean
	 */
	public function isSmsOptionValid()
	{
		return $this->smsOptionValid;
	}
	
	/**
	 * @param boolean
	 */
	public function setModemAvailable( $modemAvailable )
	{
		$this->modemAvailable = $modemAvailable;
	}
	
	/**
	 * @return boolean
	 */
	public function isModemAvailable()
	{
		return $this->modemAvailable;
	}	
	
	/**
	 * @param boolean
	 */
	public function setActive( $active )
	{
		$this->active = $active;
	}
	
	/**
	 * @return boolean
	 */
	public function isActive()
	{
		return $this->active;
	}	

	/**
	 * @param array
	 */
	public function setSmsArray( $smsArray)
	{
		$this->smsArray = $smsArray;
	}

	/**
	 * @return array
	 */
	public function getSmsArray()
	{
		return $this->smsArray;
	}

	/**
	 * @param app\services\setup\SMTSmsDto
	 */
	public function addSms( SMTSmsDto $sms )
	{
		array_push( $this->smsArray, $sms );
	}	
	
	/**
	 * Test whether sms media is active on OTU
	 *
	 * @return boolean
	 */
	public function isSmsActive()
	{
		return $this->isActive() && (count( $this->smsArray ) > 0);
	}
	
	public function stripHtmlTags()
	{
		foreach ( $this->smsArray as $smsDto )
		{
			$smsDto->stripHtmlTags();
		}
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTConfSmsDto
	 */
	static function getInstance( array &$json_array )
	{
		$instance = self::forge( get_class(), $json_array );
		$instance->stripHtmlTags();
		return $instance;
	}
}


?>