<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTRwDto;

/**
 * Container of switch Dto with configured and detected (optional: only if config!=detection) module Dtos
 *
 * @author Sylvain Desplat
 */
class SMTConfDetSwitchDto extends SMTRwDto
{
	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTSwitchDto',islist='true')
	 * @var array app\services\setup\SMTSwitchDto
	 */
	protected $configuredSwitch = array();

	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTSwitchDto',islist='true')
	 * @var array app\services\setup\SMTSwitchDto
	 */
	protected $detectedSwitch = array();

	/**
	 * Whether there is a difference between the configuration and the detection.
	 * By default, there is no difference.
	 * @var boolean
	 */
	protected $switchDifference = FALSE;

	/**
	 * Whether the switch is a DTSS module
	 * @var boolean
	 */	
	protected $dtssSwitch = FALSE;
	
	/**
	 * Whether the switch has a virtual switch
	 * @var boolean
	 */	
	protected $hasVirtualSwitch = FALSE;
	
	/**
	 * Whether the OSX have the same number of outputs
	 * @var boolean
	 */	
	protected $switchDetectedHomogeneous = TRUE;
	
	/**
	 * Whether osx power is turned on on OTU
	 * @var boolean
	 */
	protected $isOsxPowerOn = FALSE;
	
	/**
	 * Whether the OTU uses OTAM
	 * @var boolean
	 */
	protected $otamSwitch = FALSE;
	
	/**
	 * Whether the OTU supports OTAM
	 * @var boolean
	 */
	protected $otamPossible = FALSE;
	
	/**
	 * Whether detected switch is compatible with optical module
	 *
	 * @var boolean
	 */
	protected $moduleCompatibleWithSwitch = TRUE;

	
	/**
	 *
	 * @param boolean $hasOTAMSwitch
	 */
	function setOTAMSwitch( $hasOTAMSwitch)
	{
		$this->otamSwitch = $hasOTAMSwitch;
		if ( $this->otamSwitch )
		{
			$this->setOTAMPossible(TRUE);
		}
	}
	
	/**
	 *
	 * @param boolean $otamPossible
	 */
	function setOTAMPossible( $otamPossible)
	{
		$this->otamPossible= $otamPossible;
	}
	
	/**
	 *
	 * @param boolean $isDtssSwitch
	 */
	function setDtssSwitch( $isDtssSwitch )
	{
		$this->dtssSwitch = $isDtssSwitch;
	}
	
	/**
	 *
	 * @param boolean $hasVirtualSwitch
	 */
	function setVirtualSwitch( $hasVirtualSwitch )
	{
		$this->hasVirtualSwitch= $hasVirtualSwitch;
	}
		
	/**
	 * 
	 * @param boolean $switchDetectedHomogeneous
	 */
	function setSwitchDetectedHomogeneous( $switchDetectedHomogeneous )
	{
		$this->switchDetectedHomogeneous = $switchDetectedHomogeneous;
	}
	
	public function setIsOsxPowerOn($isOsxPowerOn)
	{
		$this->isOsxPowerOn= $isOsxPowerOn;
	}
	
	public function isOsxPowerOn()
	{
		return $this->isOsxPowerOn;
	}
	
	/**
	 *
	 * @return boolean $DtssSwitch
	 */
	function isDtssSwitch()
	{
		return $this->dtssSwitch;
	}
	
	/**
	 *
	 * @return boolean
	 */
	function isOTAMSwitch()
	{
		return $this->otamSwitch;
	}
	
	/**
	 *
	 * @return boolean
	 */
	function isOTAMPossible()
	{
		return $this->otamPossible;
	}
	
	/**
	 *
	 * @param boolean moduleCompatibleWithSwitch
	 */
	function setModuleCompatibleWithSwitch( $moduleCompatibleWithSwitch)
	{
		$this->moduleCompatibleWithSwitch= $moduleCompatibleWithSwitch;
	}
	
	/**
	 *
	 * @return boolean moduleCompatibleWithSwitch
	 */
	function isModuleCompatibleWithSwitch()
	{
		return $this->moduleCompatibleWithSwitch;
	}
	
	/**
	 *
	 * @param boolean $switchDifference
	 */
	function setSwitchDifference( $switchDifference )
	{
		$this->switchDifference = $switchDifference;
	}

	/**
	 *
	 * @return boolean $switchDifference
	 */
	function getSwitchDifference()
	{
		return $this->switchDifference;
	}

	/**
	 *
	 * @param app\services\setup\SMTSwitchDto $switch
	 */
	function addConfigured( $switch )
	{
	    array_push( $this->configuredSwitch, $switch );
	}

	/**
	 *
	 * @param app\services\setup\SMTSwitchDto $switch
	 */
	function addDetected( $switch )
	{
	    array_push( $this->detectedSwitch, $switch );
	}

	/**
	 *
	 * @param array app\services\setup\SMTSwitchDto $switches
	 */
	function setConfigured( $switches )
	{
	    if ($switches != NULL)
	    {
    	    foreach($switches as $switch)
    	    {
    		    array_push( $this->configuredSwitch, $switch );
    	    }
	    }
	}
	
	/**
	 *
	 * @param array app\services\setup\SMTSwitchDto $switches
	 */
	function setDetected( $switches )
	{
	    if ($switches != NULL)
	    {
    	    foreach($switches as $switch)
    	    {
    		    array_push( $this->detectedSwitch, $switch );
    	    }
	    }
	}
	
	/**
	 * 
	 * @return array app\services\setup\SMTSwitchDto $switches:
	 */
	function getDetected()
	{
	    return $this->detectedSwitch;
	}
	
	/**
	 * Serialize as Json data the object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTConfDetSwitchDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}

?>