<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTDto;

/**
 * 
 * @author Sylvain Desplat
 */
class SMTAboutDto extends SMTDto
{
    /**
     * 
     * @var string SmartOTU release version
     */
	protected $releaseVersion;
	
	/**
	 * @var string otu Release Version
	 */
	protected $otuReleaseVersion;
	
	/**
	 * @param string $releaseVersion
	 */
	public function setReleaseVersion( $releaseVersion )
	{
		$this->releaseVersion = $releaseVersion;
	}
	
	/**
	 * @param string $otuReleaseVersion
	 */
	public function setOtuReleaseVersion( $otuReleaseVersion )
	{
		$this->otuReleaseVersion = $otuReleaseVersion;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}


?>