#!/bin/bash
### BEGIN INIT INFO
# Provides:          enhance-security
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Configure other service launch according to security level
# Description:
### END INIT INFO

ENHANCE_SECURITY_FILES=("/user/harddisk/SecurityEnhance.conf" "/user/disk/SecurityEnhance.conf")
ENHANCE_SECURITY_FILE=ENHANCE_SECURITY_FILES[0]
SERVICE_TARGETED=("nfscommon" "rpcbind")

function get_service_status() {
	cat $2 | egrep "^$1" | tr -s ' ' | cut -d ' ' -f2
}

function is_service_is_used() {
    SERVICE=$1
    ls -lr /etc/rc* | grep ${SERVICE} > /dev/null
    [ $? -eq 0 ] && return 1
    return 0
}

function reset_known_host() {
    # Changing from weak to strong, remove known_host file to avoid server fingerprint mismatch
    rm -f /home/secuser/.ssh/known_hosts
    rm -f /root/.ssh/known_hosts
}

function set_ssh_no_console_mode_login()
{

    sshd_cnf="/etc/ssh/sshd_config"

    #  Disable Root login
    prmt=$(cat $sshd_cnf | grep "^PermitRootLogin" | wc -l 2>/dev/null)
    if [ $prmt -ge 1 ]; then
        sed -i 's/^PermitRootLogin.*/PermitRootLogin no/g' /etc/ssh/sshd_config
    else
        echo "PermitRootLogin no" >> $sshd_cnf
    fi

    #  Disable X11Forwarding
    sr_x11fwd=$(cat $sshd_cnf | grep "^X11Forwarding" | wc -l 2>/dev/null)
    if [ $sr_x11fwd -ge 1 ]; then
        sed -i 's/^X11Forwarding.*/X11Forwarding no/g' /etc/ssh/sshd_config
    else
        echo "X11Forwarding no" >> $sshd_cnf
    fi

    #  Disable password login for all users
    pauth=$(cat $sshd_cnf | grep "^PasswordAuthentication" | wc -l 2>/dev/null)
    if [ $pauth -ge 1 ]; then
        sed -i 's/^PasswordAuthentication.*/PasswordAuthentication no/g' /etc/ssh/sshd_config
    else
        echo "PasswordAuthentication no" >> $sshd_cnf
    fi

}

function set_ssh_strong_mode_login()
{
    sshd_cnf="/etc/ssh/sshd_config"

    #  Enable Root login
    prmt=$(cat $sshd_cnf | grep "^PermitRootLogin" | wc -l 2>/dev/null)
    if [ $prmt -ge 1 ]; then
        sed -i 's/^PermitRootLogin.*/PermitRootLogin yes/g' /etc/ssh/sshd_config
    else
        echo "PermitRootLogin yes" >> $sshd_cnf
    fi

    #  Enable X11Forwarding
    sr_x11fwd=$(cat $sshd_cnf | grep "^X11Forwarding" | wc -l 2>/dev/null)
    if [ $sr_x11fwd -ge 1 ]; then
        sed -i 's/^X11Forwarding.*/X11Forwarding yes/g' /etc/ssh/sshd_config
    else
        echo "X11Forwarding yes" >> $sshd_cnf
    fi

    #  Enable password login for all user
    pauth=$(cat $sshd_cnf | grep "^PasswordAuthentication" | wc -l 2>/dev/null)
    if [ $pauth -ge 1 ]; then
        sed -i 's/^PasswordAuthentication.*/PasswordAuthentication yes/g' /etc/ssh/sshd_config
    else
        echo "PasswordAuthentication yes" >> $sshd_cnf
    fi

}


function setup_enhance_security_mode() {

   local SSH_STRONG=`upg_environment g ssh_strong`
   local SSH_NO_CONSOLE=`upg_environment g ssh_strong_no_console`

	TELNET_STATE=$(get_service_status "telnet" $1)
	FTP_STATE=$(get_service_status "ftp" $1)
	PING_STATE=$(get_service_status "ping" $1)

	echo "Enforcing enhance security policy "
	# Following service must not start
	for i in "${SERVICE_TARGETED[@]}"
	do
	    is_service_is_used ${i}
	    [ $? -eq 1 ] && update-rc.d -f ${i} remove > /dev/null
	done

    # ftp server is conditional
	if [ "$FTP_STATE" == "no" ] ; then
	    is_service_is_used vsftpd
		[ $? -eq 1 ] && update-rc.d -f vsftpd remove > /dev/null
	else
	    is_service_is_used vsftpd
		[ $? -eq 1 ] && update-rc.d vsftpd defaults > /dev/null
	fi

    # telnet is conditional
	if [ "$TELNET_STATE" == "no" ] ; then
		sed -i -e 's/disable[ \t]*= no/disable = yes/' /etc/xinetd.d/telnet
		killall -q telnetd
	else
		sed -i -e 's/disable[ \t]*= yes/disable = no/' /etc/xinetd.d/telnet
	fi

    # response to ping is conditional
    grep icmp_echo_ignore_all /etc/sysctl.conf
    DONT_RESPOND_TO_PING=$?
    # do not respond to ping
	if [[ "$PING_STATE" == "no"  && DONT_RESPOND_TO_PING -eq 1 ]] ; then
		# Forbid response to ping
		echo "net.ipv4.icmp_echo_ignore_all = 1" >> /etc/sysctl.conf
		sysctl -p -q
	fi
	# respond to ping
	if [[ "$PING_STATE" != "no"  && DONT_RESPOND_TO_PING -eq 0 ]] ; then
		# activate response to ping
		sed -i -e '/net.ipv4.icmp_echo_ignore_all.*/d' /etc/sysctl.conf
		sysctl -p -q
	fi

   if [[ "$SSH_NO_CONSOLE" == "true" ]]; then
       set_ssh_no_console_mode_login
   else
       set_ssh_strong_mode_login
   fi

	# change SSH mode (before it started)
	readlink /etc/sshd_init.conf | grep weak > /dev/null
	[ $? -eq 0 ] && update-alternatives-chooser openssh > /dev/null && reset_known_host


    # be sure autosigned certificate for ssl are the same in both part
    diff -q /etc/pki/tls/certs/localhost.crt /mnt/fs/unused_part/etc/pki/tls/certs/localhost.crt > /dev/null
    if [ "$?" != "0" ] ; then
        mount -o remount,rw /mnt/fs/unused_part/
        cp /etc/pki/tls/certs/localhost.crt /mnt/fs/unused_part/etc/pki/tls/certs/localhost.crt
        mount -o remount,ro /mnt/fs/unused_part/
    fi
    diff -q Files /etc/pki/tls/private/localhost.key /mnt/fs/unused_part/etc/pki/tls/private/localhost.key
    if [ "$?" != "0" ] ; then
        mount -o remount,rw /mnt/fs/unused_part/
        cp /etc/pki/tls/private/localhost.key /mnt/fs/unused_part/etc/pki/tls/private/localhost.key
        mount -o remount,ro /mnt/fs/unused_part/
    fi

	exit 0
}

function setup_basic_security_mode() {
   local SSH_STRONG=`upg_environment g ssh_strong`
   local SSH_NO_CONSOLE=`upg_environment g ssh_strong_no_console`

	echo "Enforcing basic security policy "
	# Following service must be started
	for i in "${SERVICE_TARGETED[@]}"
	do
	    is_service_is_used ${i}
	    [ $? -eq 0 ] && update-rc.d ${i} defaults > /dev/null
	done

	is_service_is_used vsftpd
	[ $? -eq 0 ] && update-rc.d vsftpd defaults > /dev/null

	# xinetd provides services too, start some of them
	sed -i -e 's/disable[ \t]*= yes/disable = no/' /etc/xinetd.d/telnet

	# activate response to ping
	sed -i -e '/net.ipv4.icmp_echo_ignore_all.*/d' /etc/sysctl.conf
	sysctl -p -q

   if [[ "$SSH_NO_CONSOLE" == "true" ]]; then
       set_ssh_no_console_mode_login
   else
       set_ssh_strong_mode_login
   fi

    # manage STRONG_SSH option
    SSH_OPTION="$(upg_environment g ssh_strong)"
    if [ "$SSH_OPTION" == "true" ] ; then
            readlink /etc/sshd_init.conf | grep weak > /dev/null
	    [ $? -eq 0 ] && update-alternatives-chooser openssh > /dev/null && reset_known_host
    else
	    # change SSH mode (before it started)
	    readlink /etc/sshd_init.conf | grep weak > /dev/null
	    [[ $? -ne 0 ]] && update-alternatives-chooser opensshweak > /dev/null && reset_known_host
    fi
	exit 0
}

# Use service configuration file only if in enhance mode
if [ "$(upg_environment g Enhanced_Security)" == "true" ] ; then
    for FILE in ${ENHANCE_SECURITY_FILES[@]}; do
        if [ -f ${FILE} ] ; then
            setup_enhance_security_mode ${FILE}
        fi
    done
else
    setup_basic_security_mode
fi


exit 0
