import QtQuick 1.1
import "Viavi_Colors.js" as VColor
import libjobmgr 1.0

Rectangle {
    id: jobInfoPanel
    width: backgroundJobMgr.width - 32 // leaves space either side of panels for flicking whole structure up & down
    visible: isJobInfoPanelOn
    height: isJobInfoPanelOn ? jobInfoList.height : 0
    color: VColor.cViaviColorDarkGray
    anchors.horizontalCenter: parent.horizontalCenter
    anchors.top: jobInfoHeader.bottom
    anchors.topMargin: 3
    
    //opacity: jobInfoEditableState ? 1 : 0.8
    property bool jobInfoEditableState : true
    property int editSpacer: 20

    ListView {
        id: jobInfoList
        width: jobInfoPanel.width
        height: lineHeight * count

        Component {
            id: jobInfoLine
            
            Row {
                id: jobInfoRow
                spacing: lineSpacing
                height: lineHeight
                
                Rectangle {
                    id: jobInfoTitle
                    color: VColor.cViaviColorLightGray2
                    width: 180
                    height: parent.height
                    
                    Text {
                        id: jobInfoTitleText
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.fill: parent
                        anchors.left: parent.left
                        anchors.leftMargin: 20
                        verticalAlignment: Text.AlignVCenter
                        color: VColor.cViaviRealBlack
                        text: jobItemNameRole
                        font.bold: true
                        font.family: "DejaVu LGC Sans"
                        font.pointSize: 12
                        }
                    }
                
                Rectangle {
                    id: jobContent
                    color: VColor.cViaviColorWhite
                    width: jobInfoPanel.width - jobInfoTitle.width //- jobInfoRow.spacing
                    height: parent.height

                    function editText(txtOutput, validation) {
                       if (validation === true)
                          {
                          Job_Mgr.jobInfoModel.setData( index, txtOutput, JobInfoModel.Job_Item_Value_Role );
                          }
                           
                       keyboard.editText.disconnect( jobContent.editText );
                    }

                    Text {
                        id: jobInfoContentText
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.fill: parent
                        anchors.left: parent.left
                        anchors.leftMargin: jobInfoEditableState ? (2 * editSpacer + editableMetaphor.width) : editSpacer
                        verticalAlignment: Text.AlignVCenter
                        color: VColor.cViaviRealBlack
                        text: jobItemValueRole
                        font.bold: jobInfoEditableState ? false : true
                        //font.bold: true
                        font.family: "DejaVu LGC Sans"
                        font.pointSize: 12
                        //font.pointSize: jobInfoEditableState ? 13 : 12
                        }

                    Image {
                        id: editableMetaphor
                        width: 14
                        height: 14
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.left: parent.left
                        anchors.leftMargin: editSpacer
                        source: "/acterna/storage/look-and-feel/generic/Icon_Settings.png" // Same as used by SmartTest editors(?)
                        visible: jobInfoEditableState ? true : false
                        fillMode: Image.PreserveAspectFit
                        }

                    MouseArea {
                        anchors.fill: parent
                           
                        onClicked : {
                            saveContentPos();
                        
                            if (jobInfoEditableState)
                               {
                               keyboard.editText.connect( jobContent.editText );
                               openKeyBoard( jobInfoTitleText.text, jobInfoContentText.text );
                               console.log("[Qml] Clicked - Job is paused -> editing allowed");
                               }
                            else
                               {
                               console.log("[Qml] Clicked - Job is Active -> no editing allowed");
                               }
                           }
                        }
                    }
                
                } // end Row
            
            } // end Component
        
        model : Job_Mgr.jobInfoModel
        delegate: jobInfoLine
        
        clip: true
        interactive: contentHeight > height
        boundsBehavior: Flickable.StopAtBounds
        } // end ListView
    }
