import QtQuick 1.1
import libfo 1.0
import "Viavi_Colors.js" as VColor

Rectangle {
   id: container
   
   height: 400
   width: 700

   clip: true
   focus: true
   
   color: VColor.cViaviColorLightGray1
   
   Schematic_View_Item {
      id: schematicContainer
      
      width: parent.width
      
      anchors.top: parent.top
      
      groupModel: schematicView.GroupModel
      groupIndexDisplay: schematicView.CurrentGroupIndex
      textUnit: schematicView.TextUnit
      
      onSelectValueChanged: { schematicView.setCurrentEvent(index); }
   }
   
   Result_Table_Item {
      id: resultTableContainer
      
      width: parent.width
      
      anchors.top: schematicContainer.bottom
      anchors.bottom: eventHelperContainer.top
      
      headerModel: resultTable.TableHeader
      resultModel: resultTable.TableModel
      
      nbResultLine: resultTable.NbResultLine
      nbHeaderLine: resultTable.NbHeaderLine
   }
   
   Event_Helper {
      id: eventHelperContainer
  
      width: container.width - 100
  
      anchors.bottom: container.bottom
      anchors.bottomMargin: 20
  
      anchors.horizontalCenter: container.horizontalCenter
      
      eventAlarm: eventHelper.EventAlarm
      eventProblemText: eventHelper.EventProblem
      eventNameText: eventHelper.EventName
   }
   
   Keys.onPressed: {
      var currentEvent = schematicView.getCurrentEvent();
      
      //console.log("Keys.onPressed: " + event.key);
      
      if ( (event.key == Qt.Key_Left) && (currentEvent > 0) ) 
         {
         schematicView.setCurrentEvent( currentEvent - 1 );
         }
      else if ( (event.key == Qt.Key_Right) && (currentEvent < (schematicView.NbEvent-1) ) )
         {
         schematicView.setCurrentEvent( currentEvent + 1 );
         }
   }
}