import QtQuick 1.1
import libfo 1.0
import "Viavi_Colors.js" as VColor

Rectangle {
    id: container
    width: 500
    height: 60

    color: VColor.cViaviColorLightGray1

    border.color: VColor.cViaviColorBlack
    border.width: 4

    radius: 10
    clip: true

    property int heightLine: height / 3
    
    property int eventAlarm: 0
    property string eventProblemText: ""
    property string eventNameText: ""
    
    function get_icon( status )
    {
      var icon = "";
     
      if ( status == (-2) )
      {
         icon = "/acterna/storage/look-and-feel/generic/Cross_32_Enterprise.png";
      }
      else if ( status == (-1) )
      {
         icon = "/acterna/storage/look-and-feel/generic/Cross_32_Enterprise.png";
      }
      else if ( status == 1 )
      {
         icon = "/acterna/storage/look-and-feel/generic/Check_32_Enterprise.png";
      }
  
      return icon;
    }
    
    function get_text_color( status )
    {
      var txtColor = VColor.cViaviColorMediumBlue;
     
      if ( status == (-2) )
      {
         txtColor = VColor.cViaviColorRed;
      }
      else if ( status == (-1) )
      {
         txtColor = VColor.cViaviColorRed;
      }
      else if ( status == 1 )
      {
         txtColor = VColor.cViaviColorGreen;
      }
  
      return txtColor;
    }

    Text {
        id: eventName
        
        text: eventNameText

        width: parent.width
        height: heightLine

        clip: true

        anchors.top: parent.top
        anchors.topMargin: 10

        anchors.horizontalCenter: parent.horizontalCenter

        color: get_text_color( eventAlarm )

        font.pixelSize: 20
        font.family: "Bitstream Vera Sans Roman"
        font.bold: false

        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    Rectangle {
        id: icon

        width: 20
        height: 20

        x: ( ( eventName.width - eventName.paintedWidth ) / 2 ) - icon.width - 20

        anchors.verticalCenter: eventName.verticalCenter
        color: "transparent"
        
        Image {
            anchors.fill: parent
            source: get_icon( eventAlarm )
            fillMode: Image.PreserveAspectFit
            smooth: true
        }
    }

    Text {
        id: eventProblem
        
        text: eventProblemText

        width: parent.width
        height: heightLine

        clip: true

        anchors.top: eventName.bottom

        anchors.horizontalCenter: parent.horizontalCenter

        color: get_text_color( eventAlarm )

        font.pixelSize: 16
        font.family: "Bitstream Vera Sans Roman"
        font.bold: false

        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }
}
