import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
	id: msgbox
	border.color: VColor.cViaviColorLogoPurple
	border.width: 2
	property int label_goto: 1
	
	color: VColor.cViaviColorLightGray2
    
    Column {
    
		Text {
			width: msgbox.width
			height: msgbox.height / 3
			
			color: "white"
			font.family: "Bitstream Vera Sans Roman"
			font.bold: true
			font.pixelSize: 24
			
		    horizontalAlignment: Text.AlignHCenter
		    verticalAlignment: Text.AlignVCenter
			
			text: "Switch to Label <i style=\"color:" + VColor.cViaviColorLogoPurple + "\"\>" + label_goto + "</i>"
		}
		
		Row {
			Text {
				width: msgbox.width / 2
				height: msgbox.height / 3 
				
				color: "white"
				font.family: "Bitstream Vera Sans Roman"
				font.bold: true
				font.pixelSize: 24
				
			    horizontalAlignment: Text.AlignHCenter
			    verticalAlignment: Text.AlignVCenter
				
				text: "-"
				
				MouseArea {
					anchors.fill: parent
					
					onClicked: {
						if ( label_goto <= 10 ) {
							label_goto = 1;
						} else {
							label_goto = label_goto - 10;
						}
					}
				}
			}
			
			Text {
				width: msgbox.width / 2
				height: msgbox.height / 3
				
				color: "white"
				font.family: "Bitstream Vera Sans Roman"
				font.bold: true
				font.pixelSize: 24
				
			    horizontalAlignment: Text.AlignHCenter
			    verticalAlignment: Text.AlignVCenter
				
				text: "+"
				
				MouseArea {
					anchors.fill: parent
					
					onClicked: {
						if ( label_goto <= label_list.count - 1 ) {
							label_goto = label_goto + 10;
						} else {
							label_goto <= label_list.count;
						}
					}
				}
			}					 		 
		}
		
		Text {
			width: msgbox.width
			height: msgbox.height / 3
			
			color: "white"
			font.family: "Bitstream Vera Sans Roman"
			font.bold: true
			font.pixelSize: 24
			
		    horizontalAlignment: Text.AlignHCenter
		    verticalAlignment: Text.AlignVCenter
			
			text: "<i style=\"color:" + VColor.cViaviColorLogoPurple + "\"\>Go To</i>"
			
			MouseArea {
				anchors.fill: parent
				
				onClicked: {
					msgbox.visible = false;
					cable_co_list.Label_Index = label_goto - 1;
					label_list.positionViewAtIndex(cable_co_list.Label_Index, ListView.Center)
					label_goto = 1;
				}
			}
		}
	}
}