<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\view;

/**
 * Generates an html notification page (display messages when logout)
 * 
 * @author Sylvain Desplat
 */
class SMTNotificationPage implements SMTIPage
{
    const LOGOUT_FILE = "app/view/SMTLogoutLayout.php";
    
    private $htmlLogoutFile;
    private $message = null;
    private $action = null;
    
    function __construct( $action, $message = '' )
    {
        $this->htmlLogoutFile = self::LOGOUT_FILE;
        $this->action = $action;
        $this->message = $message;
    }
    
    /**
     * Generate a notification page with the given message
     * 
     * @return page generation status
     */
    function generatePage()
    {
        //retrieve variables used in htmlLogoutFile
        $action = $this->action;
        $message = $this->message;
        
        ob_start();
        require $this->htmlLogoutFile;
        return ob_end_flush();        
    }    
}


?>