<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2018. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\sharedmemory\SMTIMemorySupport;
use app\sharedmemory\SMTMemoryManager;
use app\util\SMTDto;

/**
 * Dto with list of OTU external switch infos
 * 
 * @author Sylvain Desplat
 */
class SMTOsxListDto extends SMTDto implements SMTIMemorySupport
{
	const OSX_TYPE_NONE = 'NONE';
	const OSX_TYPE_JDSU = 'JDSU';
	const OSX_TYPE_MOLEX = 'MOLEX';

	/**
	 * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTOsxDto',islist='true')
	 * @var array app\services\setup\SMTOsxDto
	 */
	protected $osxList = array();
	
	protected $bigTopology = FALSE;
	
	/**
	 * Whether osx power is turned on on OTU
	 * @var boolean
	 */
	protected $isOsxPowerOn = FALSE;
	
	/**
	 * Whether the OTU supports OTAM
	 * @var boolean
	 */
	protected $otamPossible = FALSE;

	/**
	 * Whether the OTU has JDSU,MOLEX or no OSUs
	 * @var string
	 */	
	protected $switchType= self::OSX_TYPE_NONE;
	
	
	/**
	 * @param app\services\setup\SMTOnmsiServerDto
	 */
	public function addOsx( SMTOsxDto $osx)
	{
		array_push( $this->osxList, $osx);
	}
	
	public function setIsBigTopology($isBigTopology)
	{
		$this->bigTopology= $isBigTopology;
	}
	
	public function isBigTopology()
	{
		return $this->bigTopology;
	}
	
	public function setIsOsxPowerOn($isOsxPowerOn)
	{
		$this->isOsxPowerOn= $isOsxPowerOn;
	}
	
	public function isOsxPowerOn()
	{
		return $this->isOsxPowerOn;
	}
	
	/**
	 *
	 * @param boolean $otamPossible
	 */
	function setOTAMPossible( $otamPossible)
	{
		$this->otamPossible= $otamPossible;
	}
	
	/**
	 *
	 * @return boolean
	 */
	function isOTAMPossible()
	{
		return $this->otamPossible;
	}
	
	/**
	 *
	 * @param boolean $jdsu
	 * @paramboolean  $otam
	 */
	function computeSwitchType( $jdsu, $otam)
	{
		if ( $jdsu )
		{
			$this->switchType = self::OSX_TYPE_JDSU;
		}
		else if ( $otam )
		{
			$this->switchType = self::OSX_TYPE_MOLEX;
		}
		else
		{
			$this->switchType = self::OSX_TYPE_NONE;
		}
	}
	
	/**
	 *
	 * @param string $osuType
	 */
	function setSwitchType( $osuType)
	{
		$this->switchType = $osuType;
	}
	
	/**
	 *
	 * @return string
	 */
	function getSwitchType()
	{
		return $this->switchType;
	}
	
	/**
	 * Identifier of OSX list 
	 *
	 * @return string
	 */
	public function getId()
	{
		return 0;
	}
	
	/**
	 * Save Dto in shared memory
	 *
	 * @throws SMTAPCMemoryException
	 */
	public function save()
	{
		SMTMemoryManager::saveDto( $this );
	}
	
	/**
	 * Delete Dto from shared memory
	 *
	 * @throws SMTAPCMemoryException
	 */
	public function delete()
	{
		SMTMemoryManager::deleteDto( $this );
	}	
	
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    
    /**
     * Returns the dto class name.
     *
     * @return the dto class name.
     */
    public static function getClass()
    {
    	return __CLASS__;
    }
    
    /**
     * Otu OTDR module cache is never obsolete: it must not be purged
     *
     * @return FALSE
     */
    public function isObsolete()
    {
    	return FALSE;
    }
    
    /**
     * No obsolescence for those data: returns current time.
     *
     * @see isObsolete()
     * @return number Timestamp of the last APC memory access (used to handle obsolescence of dtos in cache)
     */
    public function getLastAccess()
    {
    	return microtime(TRUE);
    }
    
    /**
     * No obsolescence for those data: do nothing
     *
     * @see isObsolete()
     *
     */
    public function touchAccess()
    {
    }
}
?>