from jdsu.evm import *
from jdsu.diag import *
from time import time, sleep
from jdsu.mts.uts_bdt import UtsBdt
from jdsu.mts.evdev import InputDevice
import select
import os
import os.path
import subprocess
import struct
import hashlib
from .eotdrv2_regs import *
from os import system as system_call

import traceback



@RESOURCE("analog_powersupply")
def res_analog_powersupply(mode):
    if mode:
        Log("Start analog powersupply")
        sysfs_write("/sys/platform/powersupply/en_pwr_ana", 1)
        sleep(1)
    else:
        Log("Stop analog powersupply")
        sysfs_write("/sys/platform/powersupply/en_pwr_ana", 0)
        sleep(1)

@RESOURCE("apd_powersupply")
def res_apd_powersupply(mode):
    if mode:
        Log("Start analog powersupply")
        sysfs_write("/sys/platform/powersupply/en_vcc_apd", 1)
        sleep(1)
    else:
        Log("Stop analog powersupply")
        sysfs_write("/sys/platform/powersupply/en_vcc_apd", 0)
        sleep(1)

@DIAG("Check regulator VR12/ VR3", depends=["analog_powersupply"])
def t_vcc_ana_5V(cmd):
    res = sysfs_check("/sys/platform/adc_meas_v_ana/value", "analog powersupply", vmin=float(CONST("analog_powersupply.value.min",0.475)), vmax=float(CONST("analog_powersupply.value.max",0.515)))
    if not res:
        val = sysfs_read("/sys/platform/adc_meas_v_ana/value")
        if val >0.515:
            print_error("VEE_5V_ANA HS")
        else:
            if val<0.01 :
                print_error("VCC_5V_ANA, VEE_5V_ANA, VCC_1V8 HS")
            else:
                if val<0.35 :
                    print_error("VCC_5V_ANA")
                else:
                    if val<0.475:
                        print_error("VCC_5V_ANA, VEE_5V_ANA HS")
    return res


@DIAG("Test vapd", depends=["analog_powersupply","apd_powersupply"])
def t_vcc_apd(cmd):
    #VCC_APD=(1+R1/(R2//R3))*(VFB-(R1//R3)/(R2+(R1//R3))*(VCC_5V_ANA-_R240/_R236*2*Vref*DACval/(2^16)))
    #Avec
    #R1=R251+R252
    #R2=R249+R244
    #R3=R253+R254
    #VFB = 1.6
    #Vref = 1.5
    #VCC_5V_ANA = 5
    #VccAPD = 15.358 + 85.362 * DAC/65536
    #Les tolerances pire cas sont:
    #+/- 2.3V @ 15.36V
    #+/- 2.9V @ 30V
    #+/- 5.1V @ 90V
    #+/- 5.5V @ 100V
    bdt = UtsBdt("/dev/bdt_pws1")
    analog_vapd_high_value = float(CONST("analog_vapd_high.value",90.0))
    consigne=int((analog_vapd_high_value-15.358)/85.362*65536)
    bdt.rw_register(UtsBdt.WRITE, REG_DAC_VCC_APD, 0xFFFFFFFF, consigne)
    sleep(3)
    res = sysfs_check("/sys/platform/adc_vcc_apd/value", "vapd", need=analog_vapd_high_value, acc=float(CONST("analog_vapd_high.tolerance",5)))
    analog_vapd_low_value = float(CONST("analog_vapd_low.value",30.0))
    consigne=int((analog_vapd_low_value-15.538)/85.362*65536)
    bdt.rw_register(UtsBdt.WRITE, REG_DAC_VCC_APD, 0xFFFFFFFF, consigne)
    sleep(3)
    res = res and sysfs_check("/sys/platform/adc_vcc_apd/value", "vapd", need=analog_vapd_low_value, acc=float(CONST("analog_vapd_low.tolerance",2.5))) and res
    return res


@DIAG("Test temperature", depends=["analog_powersupply"])
def t_temp(cmd):
    res = sysfs_check("/sys/class/hwmon/hwmon0/temp1_input", "CPU temperature", vmin=int(CONST("cpu.temperature.min",10000)), vmax=int(CONST("cpu.temperature.max",90000)))
    res = res and sysfs_check("/sys/platform/adc_temp_ana/value", "Board temperature", vmin=int(CONST("board.temperature.min",5)), vmax=int(CONST("board.temperature.max",70)))
    return res

@DIAG("Test VCC CPU")
def t_vcc_cpu(cmd):
    res = sysfs_check("/sys/class/hwmon/hwmon0/in1_input", "CPU VCC_INT", vmin=int(CONST("cpu.vcc_int.min",920)), vmax=int(CONST("cpu.vcc_int.max",1080)))
    res = res and sysfs_check("/sys/class/hwmon/hwmon0/in2_input", "CPU VCC_AUX", vmin=int(CONST("cpu.vcc_aux.min",1700)), vmax=int(CONST("cpu.vcc_aux.max",1900)))
    res = res and sysfs_check("/sys/class/hwmon/hwmon0/in3_input", "CPU VCC_BRAM", vmin=int(CONST("cpu.vcc_bram.min",920)), vmax=int(CONST("cpu.vcc_bram.max",1080)))
    res = res and sysfs_check("/sys/class/hwmon/hwmon0/in4_input", "CPU VCC_PINT", vmin=int(CONST("cpu.vcc_pint.min",920)), vmax=int(CONST("cpu.vcc_pint.max",1080)))
    res = res and sysfs_check("/sys/class/hwmon/hwmon0/in5_input", "CPU VCC_PAUX", vmin=int(CONST("cpu.vcc_paux.min",1700)), vmax=int(CONST("cpu.vcc_paux.max",1900)))
    res = res and sysfs_check("/sys/class/hwmon/hwmon0/in6_input", "CPU VCC_DDRO", vmin=int(CONST("cpu.vcc_ddro.min",1250)), vmax=int(CONST("cpu.vcc_ddro.max",1450)))
    return res

@DIAG("Test VEE Laser",depends=["analog_powersupply"])
def t_vee_laser(cmd):
    bdt = UtsBdt("/dev/bdt_pws1")
    vee_laser_high_value = float(CONST("vee_laser_high.value",9.0))
    consigne=int(vee_laser_high_value/10*65536)
    bdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_LASER, 0xFFFFFFFF, consigne)
    sleep(2)
    res = sysfs_check("/sys/platform/adc_meas_vee_laser/value", "vee_laser", need=vee_laser_high_value, acc=float(CONST("vee_laser_high.tolerance",0.5)))

    vee_laser_low_value = float(CONST("vee_laser_low.value",2.0))
    consigne=int(vee_laser_low_value/10*65536)
    bdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_LASER, 0xFFFFFFFF, consigne)
    sleep(2)
    res = res and sysfs_check("/sys/platform/adc_meas_vee_laser/value", "vee_laser", need=vee_laser_low_value, acc=float(CONST("vee_laser_low.tolerance",0.5)))
    return res

@DIAG("Test CLK ADC 160MHz",depends=["analog_powersupply"])
def t_clk_adc(cmd):
    try:
        (command,onoff) = cmd.split()
    except:
        print_error("# Command must be: t_clk_adc <ON|OFF>")
        return False
    if onoff == "ON":
        sysval = 1
    else:
        sysval = 0
    sysfs_write("/sys/platform/powersupply/en_test_clk",sysval)
    return None

@DIAG("Enable power supply", depends=["analog_powersupply"])
def turn_on_ana(cmd):
    return None

@DIAG("APD Shield")
def t_apd_shield(cmd):
    try:
        (command,bottom,top) = cmd.split()
    except:
        print_error("# Command must be: t_apd_shield <bottom> <top> where top and bottom in (PRESENT,ABSENT)")
        return False
    if bottom == "ABSENT" and top == "ABSENT":
        # Nominal 914 mV
        return sysfs_check("/sys/platform/adc_det_shield/value", "shield", vmin=float(CONST("shield.no_shield.min",0.833)), vmax=float(CONST("shield.no_shield.max",1.0)))
    elif bottom == "PRESENT" and top == "ABSENT":
        # Nominal 650 mV
        return sysfs_check("/sys/platform/adc_det_shield/value", "shield", vmin=float(CONST("shield.bottom.min",0.607)), vmax=float(CONST("shield.bottom.max",0.700)))
    elif bottom == "ABSENT" and top == "PRESENT":
        # Nominal 750 mV
        return sysfs_check("/sys/platform/adc_det_shield/value", "shield", vmin=float(CONST("shield.top.min",0.701)), vmax=float(CONST("shield.top.max",0.832)))
    elif bottom == "PRESENT" and top == "PRESENT":
        # Nominal 563 mV
        return sysfs_check("/sys/platform/adc_det_shield/value", "shield", vmin=float(CONST("shield.top.min",0.520)), vmax=float(CONST("shield.top.max",0.606)))
    else:
        print_error("# Command must be: t_apd_shield <bottom> <top> where top and bottom in (PRESENT,ABSENT)")
        return False



@DIAG("Get 1wire Address")
def t_onewire(cmd):
    res = sysfs_check("/sys/bus/w1/devices/w1_bus_master1/w1_master_slave_count", "OneWire Slave count", vmin=int(CONST("onewire.slavecount",1)),vmax=int(CONST("onewire.slavecount",1)))
    if res:
        sn = sysfs_read_string("/sys/bus/w1/devices/w1_bus_master1/w1_master_slaves")
        print_info("# ID: %s"%sn)
        return True
    return False




@DIAG("Test USB")
def t_usb(cmd):

    if(os.path.isdir("/sys/bus/usb/devices/1-1")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/1-1/manufacturer")
        prod = sysfs_read_string("/sys/bus/usb/devices/1-1/product")
        print_ok("# USB A OTU: %s %s"%(mfg,prod))
        return True
    else:
        print_error("# USB A OTU not detected")
        return False



@DIAG("Test SDCARD OTU")
def t_sd_otu(cmd):

    with open("/dev/urandom","rb") as f:
        buf = f.read(16*1024)

    md5buf = hashlib.md5(buf).hexdigest()

    if not os.path.exists("/dev/mmcblk0"):
        print_error("# SD Card not detected")
        return False

    if not os.path.exists("/dev/mmcblk0p1"):
        print_error("# SD Card not partitioned")
        return False

    p = subprocess.Popen("mount -o sync /dev/mmcblk0p1 /mnt/nfs", shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    if p.returncode != 0:
        print_error("# SD Card cannot be mounted")
        return False

    with open("/mnt/nfs/diag_test.rnd", "wb") as f:
        f.write(buf)

    p = subprocess.Popen("umount /dev/mmcblk0p1", shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    if p.returncode != 0:
        print_error("# SD Card cannot be unmounted")
        return False

    sleep(2)
    p = subprocess.Popen("mount -o sync /dev/mmcblk0p1 /mnt/nfs", shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    if p.returncode != 0:
        print_error("# SD Card cannot be mounted")
        return False

    if os.path.exists("/mnt/nfs/diag_test.rnd"):
        with open("/mnt/nfs/diag_test.rnd", "rb") as f:
            buf2 = f.read(16*1024)
    else:
        print_error("# SD Card file lost!!!")
        p = subprocess.Popen("umount /dev/mmcblk0p1", shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
        p.wait()
        return False
    p = subprocess.Popen("umount /dev/mmcblk0p1", shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                     stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    md5buf2 = hashlib.md5(buf).hexdigest()

    if md5buf2 != md5buf:
        print_error("# SD Card Read/Write failed")
        return False

    return True


@DIAG("Test OTU Connector")
def t_otu_connector(cmd):
    GPIO_BASE = 906 + 54
    GPIO_DYING = GPIO_BASE + 26
    GPIO_MODE_DIAG = GPIO_BASE + 27
    GPIO_DIAG_UART_DTR = GPIO_BASE + 28
    GPIO_DIAG_UART_RX = GPIO_BASE + 29
    GPIO_DIAG_UART_TX = GPIO_BASE + 30
    GPIO_OTU_SPARE0 = GPIO_BASE + 1
    GPIO_OTU_SPARE1 = GPIO_BASE + 2
    GPIO_OTU_SPARE2 = GPIO_BASE + 3
    GPIO_OTU_FAN1   = GPIO_BASE + 13
    GPIO_OTU_FAN2   = GPIO_BASE + 14
    GPIO_OTU_FAN3   = GPIO_BASE + 15
    GPIO_OTU_FAN_PWM = GPIO_BASE + 16
    GPIO_OTU_FAN_TACH1 = GPIO_BASE + 17
    GPIO_OTU_FAN_TACH2 = GPIO_BASE + 18
    GPIO_OTU_FAN_TACH3 = GPIO_BASE + 19
    GPIOS_84_TO_EOTDR = ( ("DyingIrq"  , "/sys/platform/gpio_b84_dying_irq/value"     , "/sys/class/gpio/gpio%d/value"%(GPIO_DYING)),  \
                          ("OtuSpare0" , "/sys/platform/gpio_b84_otu_spare0/value"    , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_SPARE0)),  \
                          ("OtuSpare1" , "/sys/platform/gpio_b84_otu_spare1/value"    , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_SPARE1)),  \
                          ("OtuSpare2" , "/sys/platform/gpio_b84_otu_spare2/value"    , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_SPARE2)),  \
                          ("Fan1Tach"  , "/sys/platform/gpio_b84_fan1_otu_tach/value" , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN_TACH1)),  \
                          ("Fan2Tach"  , "/sys/platform/gpio_b84_fan2_otu_tach/value" , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN_TACH2)),  \
                          ("Fan3Tach"  , "/sys/platform/gpio_b84_fan3_otu_tach/value" , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN_TACH3)),  \
                          ("UartOtuRx" , "/sys/platform/gpio_b84_uart_rx/value"       , "/sys/class/gpio/gpio%d/value"%(GPIO_DIAG_UART_RX)))

    GPIOS_EOTDR_TO_84 = ( ("Fan1OtuOn"  , "/sys/platform/gpio_b84_fan1_otu_on/value" , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN1)),  \
                          ("FanPWM"     , "/sys/platform/gpio_b84_fan_otu_pwm/value" , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN_PWM)),  \
                          ("Fan3OtuOn"  , "/sys/platform/gpio_b84_fan3_otu_on/value" , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN3)),  \
                          ("Fan2OtuOn"  , "/sys/platform/gpio_b84_fan2_otu_on/value" , "/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN2)),  \
                          ("UartOtuDtr" , "/sys/platform/gpio_b84_uart_dtr/value"    , "/sys/class/gpio/gpio%d/value"%(GPIO_DIAG_UART_DTR)),  \
                          ("UartOtuTx"  , "/sys/platform/gpio_b84_uart_tx/value"     , "/sys/class/gpio/gpio%d/value"%(GPIO_DIAG_UART_TX)))

    passed = True

    try:
        # configure gpio
        sysfs_write("/sys/class/gpio/export", GPIO_MODE_DIAG)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_MODE_DIAG), "out")
        sysfs_write("/sys/class/gpio/export", GPIO_DYING)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_DYING), "in")
        sysfs_write("/sys/class/gpio/export", GPIO_DIAG_UART_DTR)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_DIAG_UART_DTR), "out")
        sysfs_write("/sys/class/gpio/export", GPIO_DIAG_UART_RX)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_DIAG_UART_RX), "in")
        sysfs_write("/sys/class/gpio/export", GPIO_DIAG_UART_TX)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_DIAG_UART_TX), "out")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_SPARE0)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_SPARE0), "in")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_SPARE1)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_SPARE1), "in")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_SPARE2)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_SPARE2), "in")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_FAN1)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_FAN1), "out")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_FAN2)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_FAN2), "out")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_FAN3)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_FAN3), "out")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_FAN_PWM)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_FAN_PWM), "out")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_FAN_TACH1)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_FAN_TACH1), "in")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_FAN_TACH2)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_FAN_TACH2), "in")
        sysfs_write("/sys/class/gpio/export", GPIO_OTU_FAN_TACH3)
        sysfs_write("/sys/class/gpio/gpio%d/direction"%(GPIO_OTU_FAN_TACH3), "in")

        #turn on diag mode
        sysfs_write("/sys/class/gpio/gpio%d/value"%(GPIO_MODE_DIAG), 1)

        #init default values
        sysfs_write("/sys/class/gpio/gpio%d/value"%(GPIO_DIAG_UART_DTR), 0)
        sysfs_write("/sys/class/gpio/gpio%d/value"%(GPIO_DIAG_UART_TX), 0)
        sysfs_write("/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN1), 0)
        sysfs_write("/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN2), 0)
        sysfs_write("/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN3), 0)
        sysfs_write("/sys/class/gpio/gpio%d/value"%(GPIO_OTU_FAN_PWM), 0)

        for (gpioName, gpioSetB84, gpioGetEotdr) in GPIOS_84_TO_EOTDR:
            sysfs_write(gpioSetB84,0)

        val = 0
        for (gpioName, gpioGetB84, gpioSetEotdr) in GPIOS_EOTDR_TO_84:
            val = val + sysfs_read(gpioGetB84)
        if(val>0):
            passed = False
            print_error("#Fail verif init all 0")

        for (gpioName, gpioSetB84, gpioGetEotdr) in GPIOS_84_TO_EOTDR:
            sysfs_write(gpioSetB84,1)
            sleep(0.1)
            if(not sysfs_check(gpioGetEotdr, gpioName, hexval=1)):
                passed = False
            val = 0
            for (gpioName2, gpioGetB84, gpioSetEotdr) in GPIOS_EOTDR_TO_84:
                val = val + sysfs_read(gpioGetB84)
            if(val>1):
                print_error("#error verif %s"%(gpioName))
                passed = False
            sysfs_write(gpioSetB84,0)
            sleep(0.1)
            if(not sysfs_check(gpioGetEotdr, gpioName,hexval=0x0)):
                    passed = False

        for (gpioName, gpioGetB84, gpioSetEotdr) in GPIOS_EOTDR_TO_84:
            sysfs_write(gpioSetEotdr, 1)
            sleep(0.1)
            if (not sysfs_check(gpioGetB84, gpioName,hexval=1) ):
                passed = False
            val = 0
            for (gpioName2, gpioGetB84_2, gpioSetEotdr_2) in GPIOS_EOTDR_TO_84:
                val = val + sysfs_read(gpioGetB84_2)
            if(val>1):
                print_error("#error verif %s"%(gpioName2))
                passed = False
            sysfs_write(gpioSetEotdr, 0)
            sleep(0.1)
            if (not sysfs_check(gpioGetB84, gpioName,hexval=0) ):
                passed = False

    except Exception as excp:
        print_error(str(excp))
        traceback.print_exc()

    finally:
        #turn off diag mode
        sysfs_write("/sys/class/gpio/gpio%d/value"%(GPIO_MODE_DIAG), 0)

        #unexport gpio
        sysfs_write("/sys/class/gpio/unexport", GPIO_DYING)
        sysfs_write("/sys/class/gpio/unexport", GPIO_MODE_DIAG)
        sysfs_write("/sys/class/gpio/unexport", GPIO_DIAG_UART_DTR)
        sysfs_write("/sys/class/gpio/unexport", GPIO_DIAG_UART_RX)
        sysfs_write("/sys/class/gpio/unexport", GPIO_DIAG_UART_TX)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_SPARE0)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_SPARE1)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_SPARE2)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_FAN1)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_FAN2)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_FAN3)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_FAN_PWM)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_FAN_TACH1)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_FAN_TACH2)
        sysfs_write("/sys/class/gpio/unexport", GPIO_OTU_FAN_TACH3)

    return passed




@DIAG("Test USB-c RNDIS")
def t_rndis(cmd):
    timeout = 10
    address = '192.168.2.253'
    while timeout:
        response = system_call("ping -c 1 {}".format(address))
        if response == 0:
            return True
        time.sleep(1)
        timeout = timeout - 1
        print_info("Ping %s failed, will retry %d time(s)" % (address, timeout))
    return False
